1000 REM
1005 REM       Cellular automaton rule definition program
1010 REM
1015 REM       Designed and implemented by John Walker in June of 1988.
1020 REM       Extended for 8 bits of state per cell by John Walker in
1025 REM       January of 1989.
1030 REM
1035 DEFINT A-Z
1040 REM
1045 REM       To define a cellular automaton, replace the function
1050 REM       defined at line 10000 with a function defining the
1055 REM       rule for your automaton.  See the comment before line
1060 REM       10000 for information on how this function should be
1065 REM       written.  The function supplied defines the rule for
1070 REM       John Horton Conway's Life, so the program may be run
1075 REM       as-is to write the rule for that automaton.
1080 REM
1085 REM       You can preset the world type by modifying the
1090 REM       following statement:
1095 REM 
1100 REM               0 = 2D open plane
1105 REM               1 = 2D closed torus
1110 REM               2 = 1D line    8 neighbours
1115 REM               3 = 1D circle  8 neighbours
1120 REM               4 = 1D line    4 neighbours
1125 REM               5 = 1D circle  4 neighbours
1130 REM               8 = 1D line    2 neighbours
1135 REM               9 = 1D circle  2 neighbours
1140 REM              10 = 2D semitotalistic 8 sum
1145 REM              11 = 2D semitotalistic 4 sum
1150 REM              12 = Own code plane
1155 REM              13 = Own code torus
1160 REM
1165      W8 = 1
1170 REM
1175 REM       You can enable random bit generation on plane
1180 REM       1 by changing the statement below to specify how many
1185 REM       ones to generate out of 255 rolls.  Zero disables
1190 REM       the random bit generator.
1195 REM
1200      R8 = 0
1205 REM
1210 REM       You can set plane one to a special-purpose pattern by
1215 REM       modifying the next statement to be the sum of the
1220 REM       following plane 1 special function selectors:
1225 REM             0   Defined by rule or unused
1230 REM             1   Temporal phase
1235 REM             2   Horizontal texture
1240 REM             4   Vertical texture
1245 REM       hence 6   Checkerboard texture
1250 REM
1255      A8 = 0
1260 REM
1265 REM       To speed up execution, you can declare which bit planes
1270 REM       are used by the rule.  The variable F6 should be set to
1275 REM       the sum of the bits used by this rule.  If you leave it
1280 REM       set to 255, all planes are evaluated, which can take quite
1285 REM       a while.  Semitotalistic rules MUST leave F6 at 255.
1290 REM
1295      F6 = 255
1300 REM
1305 REM       To request a pattern file to be automatically loaded,
1310 REM       set the variable Q1$ to the name of the pattern file.
1315 REM
1320      Q1$ = ""
1325 REM
1330 REM       To request a colour palette file to be automatically
1335 REM       loaded, set the variable Q2$ to the name of the palette
1340 REM       file.
1345 REM
1350      Q2$ = ""
1355 REM
1360 REM       To request loading of a user own code file, set variable
1365 REM       Q3$ to the name of the own code file.
1370 REM
1375      Q3$ = ""
1380 REM
1385 REM       To generate a horizontal texture set T1 to the number of
1390 REM       of the least significant bit of the horizontal texture
1395 REM       field (0 to 7) and T2 to the number of bits of horizontal
1400 REM       texture desired (1 to 8-T1).
1405 REM
1410      T1 = -1
1415      T2 = -1
1420 REM
1425 REM       To generate a vertical texture set T3 to the number of
1430 REM       of the least significant bit of the vertical texture
1435 REM       field (0 to 7) and T4 to the number of bits of vertical
1440 REM       texture desired (1 to 8-T3).
1445 REM
1450      T3 = -1
1455      T4 = -1
1460 REM
1465 REM       To generate random input set T5 to the number of
1470 REM       of the least significant bit of the random input
1475 REM       field (0 to 7) and T6 to the number of bits of random
1480 REM       input desired (1 to 8-T5).
1485 REM
1490      T5 = -1
1495      T6 = -1
1500 REM
1505 REM       To generate an random seed set T7 to the number of
1510 REM       of the least significant bit of the initial random seed
1515 REM       field (0 to 7) and T8 to the number of bits of random
1520 REM       seed desired (1 to 8-T7).  The density of the random seed
1525 REM       is set by T9 in the range from 0 (0%--all zero bits), to
1530 REM       255 (50%--half zero bits, half one bits).
1535 REM
1540      T7 = -1
1545      T8 = -1
1550      T9 = 255
1555 REM
1560 REM       The program asks you for the name of the file into
1565 REM       which the rule should be written.  An extension of
1570 REM       ".jc" is appended if none is specified.
1575 REM
1580 LINE INPUT "Rule file name: "; A$
1585 IF INSTR(A$,".")=0 THEN A$=A$+".jc"
1590 OPEN "o",1,A$
1595 REM   width #1,255 : REM Enable this statement if CR/LFs in output file
1600 IF LEN(Q1$) = 0 THEN 1610
1605 PRINT #1,CHR$(67)+CHR$(LEN(Q1$)+1)+Q1$+CHR$(0);
1610 IF LEN(Q2$) = 0 THEN 1620
1615 PRINT #1,CHR$(68)+CHR$(LEN(Q2$)+1)+Q2$+CHR$(0);
1620 IF LEN(Q3$) = 0 THEN 1630
1625 PRINT #1,CHR$(72)+CHR$(LEN(Q3$)+1)+Q3$+CHR$(0);
1630 IF T1 >= 0 AND T2 > 0 THEN PRINT #1,CHR$(64)+CHR$(T1)+CHR$(T2);
1635 IF T3 >= 0 AND T4 > 0 THEN PRINT #1,CHR$(65)+CHR$(T3)+CHR$(T4);
1640 IF T5 >= 0 AND T6 > 0 THEN PRINT #1,CHR$(66)+CHR$(T5)+CHR$(T6);
1645 IF T7 >= 0 AND T8 > 0 THEN PRINT #1,CHR$(71)+CHR$(T7)+CHR$(T8)+CHR$(T9);
1650 REM
1655 REM   Main loop on rule table pages
1660 REM
1665 FOR I9=0 TO 255
1670    N5 = (I9 AND 128)/128
1675    O = ((I9 * 2) OR N5) AND 255
1680    IF (O AND F6) <> O THEN 1790
1685    PRINT "Page "; I9;
1690    PRINT #1,CHR$(4)+CHR$(255);
1695    IF W8 >= 12 THEN 1985
1700    IF W8 >= 10 THEN 1920
1705    IF W8 > 2 THEN 1835
1710    FOR J9=0 TO 255
1715       N1 = (J9 AND 128)/128
1720       N2 = (J9 AND  64)/64
1725       N3 = (J9 AND  32)/32
1730       N4 = (J9 AND   2)/2
1735       N6 = (J9 AND   1)
1740       N7 = (J9 AND  16)/16
1745       N8 = (J9 AND   8)/8
1750       N9 = (J9 AND   4)/4
1755       GOSUB 10000
1760       R = ((R AND 254) / 2) OR ((R AND 1) * 128)
1765       PRINT #1,CHR$(R);
1770    NEXT J9
1775    PRINT "- Generated."
1780    GOTO 1795
1785    REM Output run of 256 zeroes for skipped page
1790    PRINT #1,CHR$(2)+CHR$(255)+CHR$(0);
1795 NEXT I9
1800 PRINT #1,CHR$(6);
1805 PRINT #1,CHR$(W8)+CHR$(R8)+CHR$(A8);
1810 CLOSE 1
1815 STOP
1820    REM
1825    REM Generation for 1D neighbourhoods
1830    REM
1835    FOR J9=0 TO 255
1840       N1 = (J9 AND 128)/128
1845       N2 = (J9 AND  64)/64
1850       N3 = (J9 AND  32)/32
1855       N4 = (J9 AND  16)/16
1860       N6 = (J9 AND   8)/8
1865       N7 = (J9 AND   4)/4
1870       N8 = (J9 AND   2)/2
1875       N9 = (J9 AND   1)/1
1880       GOSUB 10000
1885       R = ((R AND 254) / 2) OR ((R AND 1) * 128)
1890       PRINT #1,CHR$(R);
1895    NEXT J9
1900    GOTO 1775
1905    REM
1910    REM Generation for semitotalistic rules
1915    REM
1920    O = INT(I9 / 8) AND 31
1925    N5 = O AND 1
1930    FOR J9=0 TO 255
1935       N1 = ((I9 AND 7) * 256) OR J9
1940       GOSUB 10000
1945       R = ((R AND 254) / 2) OR ((R AND 1) * 128)
1950       PRINT #1,CHR$(R);
1955    NEXT J9
1960    GOTO 1775
1965    REM
1970    REM Generation for own code rules: O1# = composite lookup table index,
1975    REM      I9 = High 8 bits, J9 = Low 8 bits.
1980    REM
1985    FOR J9=0 TO 255
1990       O1# = (I9 * 256.0) + J9
1995       GOSUB 10000
2000       R = ((R AND 254) / 2) OR ((R AND 1) * 128)
2005       PRINT #1,CHR$(R);
2010    NEXT J9
2015    GOTO 1775
2980 REM
2985 REM   Calculate neighbour values for 1D, 4 neighbours, 2 bits per cell
2290 REM
3000 L2 = N1 * 2 + N2
3005 L1 = N3 * 2 + N4
3010 R1 = N6 * 2 + N7
3015 R2 = N8 * 2 + N9
3020 RETURN
3080 REM
3085 REM   Calculate neighbour values for 1D, 2 neighbours, 4 bits per cell
3090 REM
3100 L1 = N1 * 8 + N2 * 4 + N3 * 2 + N4
3105 R1 = N6 * 8 + N7 * 4 + N8 * 2 + N9
3110 RETURN
9000 REM
9005 REM      Rule definition function
9010 REM
9015 REM      This function is called with variables N1 through N9
9020 REM      set to the neighbourhood of the cell.  Each is 0 if
9025 REM      the cell is off and 1 if it is on.  The neighbourhood
9030 REM      is represented as follows:
9035 REM
9040 REM            N1    N2    N3
9045 REM
9050 REM            N4    N5    N6
9055 REM
9060 REM            N7    N8    N9
9065 REM
9070 REM      Note that N5 is the cell itself.  Access to the local
9075 REM      cell state bits is provided by the variable O, which is
9080 REM      set to the cell's old state, ranging from 0 to 255.  The
9085 REM      function must compute the cell's new state, again in the
9090 REM      range from 0 to 255, store it into variable R, then return.
9095 REM
9100 REM      If a one-dimensional neighbourhood is selected (by setting
9105 REM      W8 greater than 1), the neighbour cells N1-N9 have different
9110 REM      meanings.  In every case, consider the neighbourhood of the
9115 REM      centre cell, O, as:
9120 REM
9125 REM            N1  N2  N3  N4  O  N6  N7  N8  N9
9130 REM
9135 REM      The exact meaning of N1 through N9 depends upon the tradeoff
9140 REM      between the number of neighbours and the number of bits of
9145 REM      bits of state visible from each neighbour chosen by the
9150 REM      setting of W8.  Regardless, 8 bits of state are available
9155 REM      for the cell itself, and thus the value in O will range
9160 REM      from 0 to 255.  N1 through N9 will always have values of
9165 REM      one or zero.  If 8 neighbours with one bit of visible state
9170 REM      are selected, (W8=1 or 2) these values represent the least
9175 REM      significant bit of the state of the 8 cells that closest
9180 REM      to the cell being updated, laid out along the line as shown
9185 REM      above.
9190 REM
9195 REM      If 4 neighbours with 2 bits of visible state are
9200 REM      selected by setting W8 to 4 or 5, the neighbourhood of
9205 REM      the centre cell O may be considered as:
9210 REM
9215 REM            L2  L1  O  R1  R2
9220 REM
9225 REM      where the two bit state of the four adjoining cells are
9230 REM      obtained from N1 through N9 through the expressions:
9235 REM
9240 REM      L2 = (N1 * 2) + N2
9245 REM      L1 = (N3 * 2) + N4
9250 REM      R1 = (N6 * 2) + N7
9255 REM      R2 = (N8 * 2) + N9
9260 REM
9265 REM      The values L1, L2, R1, and R2 are not automatically
9270 REM      precalculated for your rule; you may cause them to be
9275 REM      calcuated by executing a GOSUB 3000.
9280 REM
9285 REM      If 2 neighbours with 4 bits of visible state are
9290 REM      selected, by setting W8 to 8 or 9, the neighbourhood of
9295 REM      the centre cell O may be considered as:
9300 REM
9305 REM            L1  O  R1
9310 REM
9315 REM      where the four bit state of the two adjoining cells are
9320 REM      obtained from N1 through N9 through the expressions:
9325 REM
9330 REM      L1 = (N1 * 8) + (N2 * 4) + (N3 * 2) + N4
9335 REM      R1 = (N6 * 8) + (N7 * 4) + (N8 * 2) + N9
9340 REM
9345 REM      The values of L1 and L2 are not automatically
9350 REM      precalculated for your rule; you may cause them to
9355 REM      be calculated by executing a GOSUB 3100.
9360 REM
9365 REM      For semitotalistic rules (worldtype = 10 or 11), the two
9370 REM      arguments to the rule are the sum of the surrounding
9375 REM      cells, ranging from 0 to 2040, passed in N1, and the
9380 REM      least significant 5 bits of the cell's old state,
9385 REM      supplied to the rule function in O.  The new value
9390 REM      for the cell is returned in R as for any other
9395 REM      rule definition.  If variable A8 is set nonzero, it
9400 REM      is used as a mask which is ANDed with the values
9405 REM      of the neighbour cells before they are summed.
9410 REM
9415 REM      For own code rules (worldtype = 12 or 13), the raw
9420 REM      index into the lookup table is passed in the double
9425 REM      precision variable O1# (make sure to use INT if you
9430 REM      use division to extract bits from this value).  In
9435 REM      addition, I9 contains the most significant 8 bits of the
9440 REM      lookup table index and J9 contains the least significant
9445 REM      bits.  None of the other neighbour variables are initialised.
9450 REM
10000 REM  John Horton Conway's game of Life
10010 REM  Calculate number of neighbour cells currently on.  Note that
10020 REM  we don't count ourself (N5).
10030 C = N1 + N2 + N3 + N4 + N6 + N7 + N8 + N9
10040 REM If 2 neighbours on, state is unchanged (return ourself)
10050 IF C = 2 THEN R=N5 : RETURN
10060 REM If exactly 3 neighbours, turn on
10070 IF C = 3 THEN R=1 : RETURN
10080 REM Otherwise, turn off
10090 R=0
10100 RETURN
