/*

        This is a C re-implementation of Rudy Rucker's Aurora rule.
	The rule runs in a one-dimensional closed ringworld with two
	visible neighbours each providing 4 bits of state.  The rule
	is:

	   NewState = (Left + Self + Right) / 3 + 1
*/

#include "jcrule.h"

RULEDEF()
{
	static int firstime = 1;

	if (firstime) {
	   firstime = 0;
	   worldtype = 9;	   /* 2 neighbours, 4 bits each */
           strcpy(palreq, "aurora"); /* Aurora palette */
	   rseedn = 4;		   /* Seed with 4 random bits */
	   rseedb = 0;		   /* Starting at bit 0 */
	}

	return ((N2L1 + (oldstate & 15) + N2R1) / 3) + 1;
}
