/*	Life as defined by Conway, but use auxiliary status to flag cells
	which just died.  This highlights areas of activity on the screen.

	(Toffoli & Margolus, section 3.2, page 22)
*/

int jcrule(oldstate,	 nw, n	, ne,
			 w, self, e,
			 sw, s	, se
	  )
int oldstate, nw, n, ne, w, self, e, sw, s, se;
{
	int count;

	count = nw + n + ne + w + e + sw + s + se;

	if (count == 2) 	   /* If two neighbours... */
	   return self; 	   /*	...unchanged.	   */
	if (count == 3) 	   /* If exactly three...  */
	   return 1;		   /*	...cell is born.   */
	return self ? 2 : 0;	   /* Otherwise die of loneliness or
				      overpopulation. */
}
