/*      Gerard Vichniac's modified voting rule.  Like majority
	voting, but flipped in the middle:
	  
	Number of neighbours	   New state
	      0-3		      Off
	       4		      On
	       5		      Off
	      6-9		      On

	(Toffoli & Margolus, section 5.4, page 41)
*/

int jcrule(oldstate,	 nw, n	, ne,
			 w, self, e,
			 sw, s	, se
	   )
int oldstate, nw, n, ne, w, self, e, sw, s, se;
{
	int count;

	count = nw + n + ne + w + self + e + sw + s + se;

	if (count < 4 || count == 5)
	   return 2;
	return 1;
}
