/*

	The Zhabotinsky reaction a la Margolus & Toffoli.

*/

#include "jcrule.h"

#define TPPlane  1		   /* Temporal phase low-order bit */
#define TPNbits  2		   /* Two temporal phase bits */

RULEDEF()
{
	int count, alarm, alarmset, time, newself;
	static int firstime = 1;

	if (firstime) {
	   firstime = 0;
           strcpy(patreq, "zhabo");
           strcpy(palreq, "zhabo");
	}

	count = SUM_8;

	alarm = count == 2 || count > 3;

	alarmset = BITSET(3);
	time = TPHASE;

	newself = time == 0;

	time = (time > 0) ? time - 1 : 0;

	if (self == 1 && alarmset)
	   time = 3;

	return BF(alarm, 3) | BF(time, 1) | newself;
}
