/*

        Langton's self-reproducing rule

        This rule definition is used in conjunction with the user
        own code inner loop defined in langton.asm, the pattern
        langton.cap, and the palette langton.cac.

*/

class Langton extends ruletable {
    int [][] lutpage = new int[256][256];


    //  Store one value in the lookup table.

    void sltab(int c, int n, int e, int s, int w, int nouveau) {
        int luti;

        nouveau <<= 1;
        luti = BF(c, 12) | BF(n, 9) | BF(e, 6) | BF(s, 3) | BF(w, 0);
        lutpage[(luti >> 8) & 0xFF][luti & 0xFF] = nouveau;
    }

    //  Set a value in all reflections.

    void s(int c, int n, int e, int s, int w, int nouveau) {
        sltab(c, n, e, s, w, nouveau);
        sltab(c, e, s, w, n, nouveau);
        sltab(c, s, w, n, e, nouveau);
        sltab(c, w, n, e, s, nouveau);
    }

    //  Initialise the lookup table.

    void initrule() {
        s(0, 0, 0, 0, 1, 2);
        s(0, 0, 0, 0, 6, 3);
        s(0, 0, 0, 0, 7, 1);
        s(0, 0, 0, 1, 1, 2);
        s(0, 0, 0, 1, 2, 2);
        s(0, 0, 0, 1, 3, 2);
        s(0, 0, 0, 2, 1, 2);
        s(0, 0, 0, 2, 6, 2);
        s(0, 0, 0, 2, 7, 2);
        s(0, 0, 0, 5, 2, 5);
        s(0, 0, 0, 6, 2, 2);
        s(0, 0, 0, 7, 2, 2);
        s(0, 0, 1, 0, 2, 2);
        s(0, 0, 2, 1, 2, 5);
        s(0, 0, 2, 3, 2, 2);
        s(0, 0, 5, 2, 2, 2);
        s(0, 1, 2, 3, 2, 1);
        s(0, 1, 2, 4, 2, 1);
        s(0, 1, 2, 5, 2, 5);
        s(0, 1, 2, 6, 2, 1);
        s(0, 1, 2, 7, 2, 1);
        s(0, 1, 2, 7, 5, 1);
        s(0, 1, 4, 2, 2, 1);
        s(0, 1, 4, 3, 2, 1);
        s(0, 1, 4, 4, 2, 1);
        s(0, 1, 4, 7, 2, 1);
        s(0, 1, 6, 2, 5, 1);
        s(0, 1, 7, 2, 2, 1);
        s(0, 1, 7, 2, 5, 5);
        s(0, 1, 7, 5, 2, 1);
        s(0, 1, 7, 6, 2, 1);
        s(0, 1, 7, 7, 2, 1);
        s(0, 2, 5, 2, 7, 1);
        s(1, 0, 0, 0, 1, 1);
        s(1, 0, 0, 0, 6, 1);
        s(1, 0, 0, 0, 7, 7);
        s(1, 0, 0, 1, 1, 1);
        s(1, 0, 0, 1, 2, 1);
        s(1, 0, 0, 2, 1, 1);
        s(1, 0, 0, 2, 4, 4);
        s(1, 0, 0, 2, 7, 7);
        s(1, 0, 0, 5, 1, 1);
        s(1, 0, 1, 0, 1, 1);
        s(1, 0, 1, 1, 1, 1);
        s(1, 0, 1, 2, 4, 4);
        s(1, 0, 1, 2, 7, 7);
        s(1, 0, 2, 0, 2, 6);
        s(1, 0, 2, 1, 2, 1);
        s(1, 0, 2, 2, 1, 1);
        s(1, 0, 2, 2, 4, 4);
        s(1, 0, 2, 2, 6, 3);
        s(1, 0, 2, 2, 7, 7);
        s(1, 0, 2, 3, 2, 7);
        s(1, 0, 2, 4, 2, 4);
        s(1, 0, 2, 6, 2, 6);
        s(1, 0, 2, 6, 4, 4);
        s(1, 0, 2, 6, 7, 7);
        s(1, 0, 2, 7, 2, 7);
        s(1, 0, 5, 4, 2, 7);
        s(1, 1, 1, 1, 2, 1);
        s(1, 1, 1, 2, 2, 1);
        s(1, 1, 1, 2, 4, 4);
        s(1, 1, 1, 2, 5, 1);
        s(1, 1, 1, 2, 6, 1);
        s(1, 1, 1, 2, 7, 7);
        s(1, 1, 1, 5, 2, 2);
        s(1, 1, 2, 1, 2, 1);
        s(1, 1, 2, 2, 2, 1);
        s(1, 1, 2, 2, 4, 4);
        s(1, 1, 2, 2, 5, 1);
        s(1, 1, 2, 2, 7, 7);
        s(1, 1, 2, 3, 2, 1);
        s(1, 1, 2, 4, 2, 4);
        s(1, 1, 2, 6, 2, 1);
        s(1, 1, 2, 7, 2, 7);
        s(1, 1, 3, 2, 2, 1);
        s(1, 2, 2, 2, 4, 4);
        s(1, 2, 2, 2, 7, 7);
        s(1, 2, 2, 4, 3, 4);
        s(1, 2, 2, 5, 4, 7);
        s(1, 2, 3, 2, 4, 4);
        s(1, 2, 3, 2, 7, 7);
        s(1, 2, 4, 2, 5, 5);
        s(1, 2, 4, 2, 6, 7);
        s(1, 2, 5, 2, 7, 5);
        s(2, 0, 0, 0, 1, 2);
        s(2, 0, 0, 0, 2, 2);
        s(2, 0, 0, 0, 4, 2);
        s(2, 0, 0, 0, 7, 1);
        s(2, 0, 0, 1, 2, 2);
        s(2, 0, 0, 1, 5, 2);
        s(2, 0, 0, 2, 1, 2);
        s(2, 0, 0, 2, 2, 2);
        s(2, 0, 0, 2, 3, 2);
        s(2, 0, 0, 2, 4, 2);
        s(2, 0, 0, 2, 6, 2);
        s(2, 0, 0, 2, 7, 2);
        s(2, 0, 0, 3, 2, 6);
        s(2, 0, 0, 4, 2, 3);
        s(2, 0, 0, 5, 1, 7);
        s(2, 0, 0, 5, 2, 2);
        s(2, 0, 0, 5, 7, 5);
        s(2, 0, 0, 7, 2, 2);
        s(2, 0, 1, 0, 2, 2);
        s(2, 0, 1, 1, 2, 2);
        s(2, 0, 1, 2, 2, 2);
        s(2, 0, 1, 4, 2, 2);
        s(2, 0, 1, 7, 2, 2);
        s(2, 0, 2, 0, 2, 2);
        s(2, 0, 2, 0, 3, 2);
        s(2, 0, 2, 0, 5, 2);
        s(2, 0, 2, 0, 7, 3);
        s(2, 0, 2, 1, 2, 2);
        s(2, 0, 2, 1, 5, 2);
        s(2, 0, 2, 2, 1, 2);
        s(2, 0, 2, 2, 2, 2);
        s(2, 0, 2, 2, 7, 2);
        s(2, 0, 2, 3, 2, 1);
        s(2, 0, 2, 4, 2, 2);
        s(2, 0, 2, 4, 5, 2);
        s(2, 0, 2, 5, 5, 2);
        s(2, 0, 2, 6, 2, 2);
        s(2, 0, 2, 7, 2, 2);
        s(2, 0, 3, 1, 2, 2);
        s(2, 0, 3, 2, 1, 6);
        s(2, 0, 3, 2, 2, 6);
        s(2, 0, 3, 4, 2, 2);
        s(2, 0, 4, 2, 2, 2);
        s(2, 0, 5, 1, 2, 2);
        s(2, 0, 5, 2, 1, 2);
        s(2, 0, 5, 2, 2, 2);
        s(2, 0, 5, 5, 2, 1);
        s(2, 0, 5, 7, 2, 5);
        s(2, 0, 6, 2, 2, 2);
        s(2, 0, 6, 7, 2, 2);
        s(2, 0, 7, 1, 2, 2);
        s(2, 0, 7, 2, 2, 2);
        s(2, 0, 7, 4, 2, 2);
        s(2, 0, 7, 7, 2, 2);
        s(2, 1, 1, 2, 2, 2);
        s(2, 1, 1, 2, 6, 1);
        s(2, 1, 2, 2, 2, 2);
        s(2, 1, 2, 2, 4, 2);
        s(2, 1, 2, 2, 6, 2);
        s(2, 1, 2, 2, 7, 2);
        s(2, 1, 4, 2, 2, 2);
        s(2, 1, 5, 2, 2, 2);
        s(2, 1, 6, 2, 2, 2);
        s(2, 1, 7, 2, 2, 2);
        s(2, 2, 2, 2, 7, 2);
        s(2, 2, 2, 4, 4, 2);
        s(2, 2, 2, 4, 6, 2);
        s(2, 2, 2, 7, 6, 2);
        s(2, 2, 2, 7, 7, 2);
        s(3, 0, 0, 0, 1, 3);
        s(3, 0, 0, 0, 2, 2);
        s(3, 0, 0, 0, 4, 1);
        s(3, 0, 0, 0, 7, 6);
        s(3, 0, 0, 1, 2, 3);
        s(3, 0, 0, 4, 2, 1);
        s(3, 0, 0, 6, 2, 2);
        s(3, 0, 1, 0, 2, 1);
        s(3, 0, 2, 5, 1, 1);
        s(4, 0, 2, 2, 2, 1);
        s(4, 0, 2, 3, 2, 6);
        s(4, 0, 3, 2, 2, 1);
        s(5, 0, 0, 0, 2, 2);
        s(5, 0, 0, 2, 1, 5);
        s(5, 0, 0, 2, 2, 5);
        s(5, 0, 0, 2, 3, 2);
        s(5, 0, 0, 2, 7, 2);
        s(5, 0, 2, 0, 2, 2);
        s(5, 0, 2, 1, 2, 2);
        s(5, 0, 2, 1, 5, 2);
        s(5, 0, 2, 2, 4, 4);
        s(5, 0, 2, 7, 2, 2);
        s(5, 1, 2, 1, 2, 2);
        s(5, 1, 2, 4, 2, 2);
        s(5, 1, 2, 7, 2, 2);
        s(6, 0, 0, 0, 1, 1);
        s(6, 0, 0, 0, 2, 1);
        s(6, 1, 2, 1, 2, 5);
        s(6, 1, 2, 1, 3, 1);
        s(6, 1, 2, 2, 2, 5);
        s(7, 0, 0, 0, 7, 7);
        s(7, 0, 2, 2, 2, 1);
        s(7, 0, 2, 2, 5, 1);
        s(7, 0, 2, 3, 2, 1);
        s(7, 0, 2, 5, 2, 5);
    }

    void jcruleModes() {
        initrule();
        setWorld(13);                 // Own code torus
        setPaletteRequest("langton");
        setPatternRequest("langton");
        setOwnCodeRequest("langton");
    }

    int jcrule(int oldstate) {
        return lutpage[(oldstate >> 8) & 0xFF][oldstate & 0xFF];
    }
}

public class langton {
    public static void main(String args[]) {
        (new Langton()).generateRuleFile("langton");
    }
}
