
;       Own code inner loop for Langton's self-reproducing rule

;	This is an evaluator for von Neumann neighbourhood with
;	3 bits of state visible from each neighbour and 4 bits
;       of local state.  For Langton's rule only 3 bits of state
;	are required.

;	The actual state codes in the the table and the codes fetched
;	from the lookup table are actually twice the original Langton
;	codes.	This compensates for the one bit rotation in the state
;	map and let us dispense with five shift instructions that would
;	otherwise be required in the inner loop.  The colour palette 
;	used with this rule compensates for the doubling of the state
;	numbers.

codes	segment byte
	assume	cs:codes

	org	100h

NORTH	equ	[bp-322]
WEST	equ	[bp-1]
SELF	equ	[bp]
EAST	equ	[bp+1]
SOUTH	equ	[bp+322]

inline	equ	8		; number of inline expansions

langton proc	far

	mov	dx,320/inline	; load row length counter
	mov	cl,3		; load shift count

ocbyte:
	rept	inline
	mov	ah,WEST
	ror	ax,cl
	mov	ah,SOUTH
	ror	ax,cl
	mov	ah,EAST
	ror	ax,1
	ror	ax,1
	mov	bl,al
	ror	ax,1
	mov	ah,NORTH
	ror	ax,cl
	mov	ah,SELF
	ror	ax,cl
	ror	ax,1
	mov	bh,al

	mov	al,[bx] 	; load new value from lookup table
	inc	bp		; advance along row
	stosb			; store into new state table
	endm

	dec	dx		; more to update ?

	if	((offset $) - (offset ocbyte)) LT 128
	jnz	ocbyte		; yes.	keep on going
	else
	jz	ocdone
	jmp	ocbyte
ocdone: 
	endif

	ret
langton endp

codes	ends
	end	langton
