
;	Own code evaluator for optimal solution to Laplace equation
;	in the plane.  The rule is embodied totally in the code--no
;	lookup table is used.

codes	segment byte
	assume	cs:codes

	org	100h

NWEST	equ	[bp-323]
NORTH	equ	[bp-322]
NEAST	equ	[bp-321]
WEST	equ	[bp-1]
SELF	equ	[bp]
EAST	equ	[bp+1]
SWEST	equ	[bp+321]
SOUTH	equ	[bp+322]
SEAST	equ	[bp+323]

laplace proc	far

	mov	dx,320		; load row length counter
	mov	cl,20		; load divisor

lbyte:	xor	ah,ah
	mov	bl,WEST
	rol	bl,1
	xor	bh,bh
	mov	al,EAST
	rol	al,1
	add	bx,ax
	mov	al,NORTH
	rol	al,1
	add	bx,ax
	mov	al,SOUTH
	rol	al,1
	add	bx,ax
	add	bx,bx		; * 2
	add	bx,bx		; * 4

	mov	al,NWEST
	rol	al,1
	add	bx,ax
	mov	al,NEAST
	rol	al,1
	add	bx,ax
	mov	al,SEAST
	rol	al,1
	add	bx,ax
	mov	al,SWEST
	rol	al,1

	add	ax,bx		; complete weighted sum
	add	ax,10		; round up in divide
	div	cl		; divide to normalise result
	ror	al,1		; shift into state map bit ordering

	inc	bp		; advance along row
	stosb			; store into new state table

	dec	dx		; more to update ?
	jnz	lbyte		; yes.	keep on going

	ret
laplace endp

codes	ends
	end	laplace
