/*

				Laplace equation in the plane

	   by John Walker  --  March 1997

	   New = ((N + S + E + W) * 4) + (NW + NE + SW + SE)) / 20

*/

#include <windows.h>

/*	If POINTERS is defined the evalUpdate function will use
	pointer arithmetic rather than array indexing to access
	the state vectors.  Depending on the compiler's optimiser,
	this may or may not be faster.  */

#define POINTERS

/*	If IULOOK is defined, conversions between internal
	(one bit rotated) and user states are done using a
	lookup table supplied in the file iu.h instead of
	in-line calculation.  Most evaluators run faster
	with IULOOK defined, but this can depend on the
	compiler, and interact with whether POINTERS is
	defined.  Experimentation is the only way to determine
	the optimal settings for your compiler and evalUpdate
	function definition.  */
	
#define IULOOK

#ifdef IULOOK
#include "iu.h"
#define UtoI(x)     utoi[x]
#define ItoU(x)		itou[x]
#else
#define UtoI(x)     (((((x) >> 1) & 0x7F) | ((x) << 7)) & 0xFF)
#define ItoU(x)     ((((x) << 1) | (((x) >> 7) & 1)) & 0xFF)
#endif

/*	Update map procedure  */

void FAR PASCAL _export evalUpdate(DWORD context,
								   LPBYTE oldvec, LPBYTE newvec, LPBYTE lut,
								   int torus, int auxval, long generation)
{
	unsigned int x, y;
	
#ifdef POINTERS

	/*	Pointer arithmetic version of evaluator.  */
	
	LPBYTE op, np;

#define NWEST	ItoU(*(op - 323))
#define NORTH	ItoU(*(op - 322))
#define NEAST	ItoU(*(op - 321))
#define WEST	ItoU(*(op - 1))
#define SELF 	ItoU(*op)
#define EAST	ItoU(*(op + 1))   
#define SWEST	ItoU(*(op + 321))
#define SOUTH	ItoU(*(op + 322))
#define SEAST	ItoU(*(op + 323))

#define NEWSELF	*np
    
    op = oldvec + 323;
    np = newvec + 323;
	for (y = 0; y < 200; y++) {
		for (x = 0; x < 320; x++) {
			unsigned int laplace = 
				((NORTH + SOUTH + EAST + WEST) * 4 +
				  (NWEST + NEAST + SWEST + SEAST) + 10) / 20;
				
			NEWSELF++ = UtoI(laplace);
			op++;
		}
		op += 2;
		np += 2;
	}

#else

	/* Array indexing version of evaluator.  */


#define NWEST	ItoU(oldvec[y * 322 + x])
#define NORTH	ItoU(oldvec[y * 322 + x + 1])
#define NEAST	ItoU(oldvec[y * 322 + x + 2])
#define WEST	ItoU(oldvec[(y + 1) * 322 + x])
#define SELF 	ItoU(oldvec[(y + 1) * 322 + x + 1])
#define EAST	ItoU(oldvec[(y + 1) * 322 + x + 2])   
#define SWEST	ItoU(oldvec[(y + 2) * 322 + x])
#define SOUTH	ItoU(oldvec[(y + 2) * 322 + x + 1])
#define SEAST	ItoU(oldvec[(y + 2) * 322 + x + 2])

#define	NEWSELF	newvec[(y + 1) * 322 + x + 1]

	for (y = 0; y < 200; y++) {
		for (x = 0; x < 320; x++) {
			unsigned int laplace = 
				((NORTH + SOUTH + EAST + WEST) * 4 +
				  (NWEST + NEAST + SWEST + SEAST) + 10) / 20;
				
			NEWSELF = UtoI(laplace);
		}
	}
#endif	
}						

/*	Library initialisation  */

int FAR PASCAL LibMain(HINSTANCE hInstance, WORD wDataSeg, WORD wHeapSize,
					   LPSTR lpszCmdLine)
{
	if (wHeapSize > 0) {
		UnlockData(0);
	}
	return 1;
}					  

/*	Library termination handler  */

int FAR PASCAL _export WEP(int nParam)
{
	return 1;
}

