
;       Own code evaluator for "meltdown"

;	This own code routine illustrates a moderately tricky own code
;	application.  It applies a bubble sort algorithm to each
;	column of the map on each generation to propagate bytes with
;	higher state codes downward until they reach the bottom line.
;	This makes histograms from a map, sorted by state code,
;	precisely like the [Margolus&Toffoli87] SAFE-PASS rule (Page
;	78).  Unlike that rule, this own code routine sorts any map
;	states, 0 to 255, and requires neither a lookup table nor any
;	housekeeping bits.  Thus, you can load it after running
;	another rule and easily produce a histogram.

;	Own code designers will note two unusual properties of this
;       routine.  First, it performs an entire generation's update in
;       one call.  When it's done, it sets SI to 1, which causes CA to
;	conclude that the map update is complete.  Second, it updates
;	the old map in place and then blast copies it to the new map.
;	This is permissible behaviour, and faster than performing the
;	old to new copy in the inner loop.

;	We deliberately slow down the sorting process by skipping
;	after we swap a pair of bytes and by using the outer generation
;	loop to perform multiple updates rather than employing our own
;	inner loop because the result looks more interesting on the
;	screen and better reveals the action of the rule.  If we had our own
;	inner loop, the screen would simply emerge sorted in one
;	generation, which would be more practical for histogram making,
;       but wouldn't illustrate the mechanism at work.

;	This is a legitimate CA rule, and can be seen as a simple model
;	for rules regarding cells that move, retaining their identity,
;	which may prove useful in artificial life investigations.

codes	segment byte
	assume	cs:codes

	org	100h

SELF	equ	[bp]
SOUTH	equ	[bp+322]

meltdown proc	 far

	mov	dx,320		; load row length counter
	mov	bx,bp		; save initial map pointer

mcol:	mov	cx,199		; load screen length in lines
	mov	bp,bx		; reset to top of next column
mrow:	mov	al,SELF 	; load cell
	cmp	al,SOUTH	; is South neighbour greater ?
	jbe	mnoact		; no.  already sorted
	xchg	al,SOUTH	; yes.	swap with Clem, our Southern neighbour
	mov	SELF,al 	; and propagate him up to Yankee-land
	add	bp,322		; skip this swapped pair to make...
	dec	cx		; ...the sorting process look like melting
mnoact: add	bp,322		; increment to next row
	dec	cx		; more rows to update ?
	jg	mrow		; loop processing this column
	inc	bx		; advance to next column
	dec	dx		; more columns to update ?
	jnz	mcol		; yes.	go do it

	push	ds		; save lookup table pointer
	push	ss		; get source map on stack
	pop	ds		; point DS at source map
	mov	si,322		; copy starting at first real line
	mov	di,322		; to same position in output map
	mov	cx,(322*200)/2	; load length in words
	rep	movsw		; blast old map to new
	pop	ds		; restore DS

	mov	si,1		; indicate update all done
	ret
meltdown endp

codes	ends
	end	meltdown
