/*

			Rotate blocks of map

		 A sample user evaluator DLL
		 
	   by John Walker  --  December 1995

*/

#include <windows.h>
#include <windowsx.h>
#include <memory.h>

/*	If TEST is defined, code is generated to allocate and free
	a context buffer, "do something" when the configuration
	function is called, etc.  This is just to make sure the
	linkages work.  */
	
#define TEST

/*  If DEBUG is defined in conjunction with TEST, message boxes
	are displayed to dump arguments, confirm functions were
	called, and so on.  */
	
/* #define DEBUG */

/*	Initialisation procedure  */

DWORD FAR PASCAL _export evalInit(HWND parentWindow,
		   						  int screenX, int screenY,
		   						  DWORD lutSize)
{
#ifdef TEST
	LPSTR contextBuffer;
#ifdef DEBUG	
	char s[132];
	
	wsprintf(s, "Screen x = %d, y = %d, LUT size = %ld",
		screenX, screenY, lutSize);
	MessageBox(parentWindow, s, "Rotblock Initialisation", MB_OK);
#endif
	contextBuffer = GlobalAllocPtr(GPTR, 256L);
	if (contextBuffer == NULL) {
		MessageBox(parentWindow, "Can't allocate context buffer!", "Rotblock Initialisation", MB_OK);
	}
	return (DWORD) contextBuffer;
#else
	return 0;
#endif
}

/*	Configuration procedure  */

void FAR PASCAL _export evalConfig(DWORD context, HWND parentWindow)
{
#ifdef TEST
	long FAR *lp;
#ifdef DEBUG
	char s[132];
#endif	
	 
	lp = (long FAR *) context;
	lp[1]++;   
#ifdef DEBUG
	wsprintf(s, "Configuration call number %ld", lp[1]);
	MessageBox(parentWindow, s, "Rotblock Configuration", MB_OK);
#endif
#endif
}		   							 

/*	Termination procedure  */

void FAR PASCAL _export evalTerm(DWORD context)
{
#ifdef TEST
	long FAR *lp;
#ifdef DEBUG
	char s[132];
#endif
	
	lp = (long FAR *) context;
#ifdef DEBUG
	wsprintf(s, "Generations: %ld, Configurations: %ld", lp[0], lp[1]);
	MessageBox(NULL, s, "Rotblock Termination", MB_OK);
	GlobalFreePtr((LPSTR) context);
#endif
#endif
}		   							 

/*	Update map procedure  */

void FAR PASCAL _export evalUpdate(DWORD context,
								   LPBYTE oldvec, LPBYTE newvec, LPBYTE lut,
								   int torus, int auxval, long generation)
{
	unsigned int x, y, k;
	LPBYTE ip, op;
#ifdef TEST
	long FAR *lp;
	
	lp = (long FAR *) context;
	lp[0]++;
#endif
    
    /*	Verify generation count correct by doing nothing on
    	generation 1.  */
    	
	if (generation == 1) {
		_fmemcpy(newvec, oldvec, 322u * 202u);
		return;
	}   

#define BLOCK	40
#define FRAME	(BLOCK / 2)

	for (y = 0; y < 200 / BLOCK; y++) {
		for (x = 0; x < 320 / BLOCK; x++) {
			ip = oldvec + (((y * BLOCK) + 1) * 322) + (x * BLOCK) + 1;
			op = newvec + (((y * BLOCK) + 1) * 322) + (x * BLOCK) + 1;
			for (k = 0; k < FRAME; k++) {
				_fmemcpy(op + k * 322 + FRAME, ip + k * 322, FRAME);
				_fmemcpy(op + (k + FRAME) * 322 + FRAME, ip + k * 322 + FRAME, FRAME);
				_fmemcpy(op + (k + FRAME) * 322, ip + (k + FRAME) * 322 + FRAME, FRAME);
				_fmemcpy(op + k * 322, ip + (k + FRAME) * 322, FRAME);
			}
		}
	}
}						

/*	Library initialisation  */

int FAR PASCAL LibMain(HINSTANCE hInstance, WORD wDataSeg, WORD wHeapSize,
					   LPSTR lpszCmdLine)
{
	if (wHeapSize > 0) {
		UnlockData(0);
	}
	return 1;
}					  

/*	Library termination handler  */

int FAR PASCAL _export WEP(int nParam)
{
	return 1;
}

