
;       Own code evaluator for "runny paint"

;	This own code routine illustrates a moderately tricky own code
;       application.  It simulates "runny paint" by propagating nonzero
;	states downward until they encounter a another nonzero cell.

;	Own code designers will note two unusual properties of this
;       routine.  First, it performs an entire generation's update in
;       one call.  When it's done, it sets SI to 1, which causes CA to
;	conclude that the map update is complete.  Second, it updates
;	the old map in place and then blast copies it to the new map.
;	This is permissible behaviour, and faster than performing the
;	old to new copy in the inner loop.

;	We deliberately slow down the sorting process by skipping
;	after we swap a pair of bytes and by using the outer generation
;	loop to perform multiple updates rather than employing our own
;	inner loop because the result looks more interesting on the
;	screen and better reveals the action of the rule.  If we had our own
;	inner loop, the screen would simply emerge sorted in one
;	generation, which would be more practical for histogram making,
;       but wouldn't illustrate the mechanism at work.

codes	segment byte
	assume	cs:codes

	org	100h

SELF	equ	[bp]
SOUTH	equ	[bp+322]

runny	proc	far

	mov	dx,320		; load row length counter
	mov	bx,bp		; save initial map pointer
	xor	ah,ah		; clear AH

mcol:	mov	cx,199		; load screen length in lines
	mov	bp,bx		; reset to top of next column
mrow:	cmp	ah,SOUTH	; is South neighbour zero ?
	jne	mnoact		; no.  already paint there
	mov	al,SELF 	; load ourselves
	cmp	ah,al		; are we zero ?
	je	mnoact		; yes.	nothing to do
	mov	SOUTH,al	; swap us southward
	mov	SELF,ah 	; clear ourselves
	add	bp,322		; skip this swapped pair to make...
	dec	cx		; ...the sorting process look like melting
mnoact: add	bp,322		; increment to next row
	dec	cx		; more rows to update ?
	jg	mrow		; loop processing this column
	inc	bx		; advance to next column
	dec	dx		; more columns to update ?
	jnz	mcol		; yes.	go do it

	push	ds		; save lookup table pointer
	push	ss		; get source map on stack
	pop	ds		; point DS at source map
	mov	si,322		; copy starting at first real line
	mov	di,322		; to same position in output map
	mov	cx,(322*200)/2	; load length in words
	rep	movsw		; blast old map to new
	pop	ds		; restore DS

	mov	si,1		; indicate update all done
	ret
runny	endp

codes	ends
	end	runny
