
;	Four neighbour semitotalistic evaluator defined as own-code
;	routine.

;	This assumes a lookup table built with the upper 6 bits of the
;	index representing the local state of the centre cell and the
;	lower 10 bits the arithmetic sum for the four neighbouring
;	cells (0 to 1020).  Note this is NOT compatible with the
;	built-in world type of 11--this definition gives you one more
;	bit of local state and lets you choose either an open or a
;	closed world.

;	Designed and implemented by John Walker in March of 1989.

codes	segment byte
	assume	cs:codes

	org	100h

;	Neighbours

NORTH	equ	[bp-322]
WEST	equ	[bp-1]
SELF	equ	[bp]
EAST	equ	[bp+1]
SOUTH	equ	[bp+322]

semi4	proc	far
	mov	dx,320		; load row length counter
	mov	cl,2		; load shift count
ocbyte:
	xor	ah,ah
	mov	bl,WEST
	rol	bl,1
	xor	bh,bh
	mov	al,EAST
	rol	al,1
	add	bx,ax
	mov	al,NORTH
	rol	al,1
	add	bx,ax
	mov	al,SOUTH
	rol	al,1

	mov	ah,SELF
	rol	ah,1
	shl	ah,cl		; place its low-order 6 bits at top of AH
	add	bx,ax		; add sum of 8 surrounding cells
	mov	al,[bx] 	; load new value from lookup table

	inc	bp		; advance along row
	stosb			; store into new state table

	dec	dx		; more to update ?

	jnz	ocbyte		; yes.	keep on going

	ret			; all done.  return to caller
semi4	endp

codes	ends
	end	semi4
