
;	Eight neighbour semitotalistic evaluator defined as own-code
;	routine.

;	This code is compatible with the worldtype = 10 built-in evaluator
;	and is provided here as an example of an own-code definition.

codes	segment byte
	assume	cs:codes

	org	100h

;	Neighbours

NWEST	equ	[bp-323]
NORTH	equ	[bp-322]
NEAST	equ	[bp-321]
WEST	equ	[bp-1]
SELF	equ	[bp]
EAST	equ	[bp+1]
SWEST	equ	[bp+321]
SOUTH	equ	[bp+322]
SEAST	equ	[bp+323]

semi8	proc	far
	mov	dx,320		; load row length counter
	mov	cl,3		; load shift count
ocbyte:
	xor	ah,ah
	mov	bl,WEST
	rol	bl,1
	xor	bh,bh
	mov	al,EAST
	rol	al,1
	add	bx,ax
	mov	al,NWEST
	rol	al,1
	add	bx,ax
	mov	al,NORTH
	rol	al,1
	add	bx,ax
	mov	al,NEAST
	rol	al,1
	add	bx,ax
	mov	al,SWEST
	rol	al,1
	add	bx,ax
	mov	al,SOUTH
	rol	al,1
	add	bx,ax
	mov	al,SEAST
	rol	al,1

	mov	ah,SELF
	rol	ah,1
	shl	ah,cl		; place its low-order 5 bits at top of AH
	add	bx,ax		; add sum of 8 surrounding cells
	mov	al,[bx] 	; load new value from lookup table

	inc	bp		; advance along row
	stosb			; store into new state table

	dec	dx		; more to update ?

	jnz	ocbyte		; yes.	keep on going

	ret			; all done.  return to caller
semi8	endp

codes	ends
	end	semi8
