
;	Own code evaluator for von Neumann neighbourhood with
;	3 bits of state visible from each neighbour and 4 bits
;	of local state.

codes	segment byte
	assume	cs:codes

	org	100h

NWEST	equ	[bp-323]
NORTH	equ	[bp-322]
NEAST	equ	[bp-321]
WEST	equ	[bp-1]
SELF	equ	[bp]
EAST	equ	[bp+1]
SWEST	equ	[bp+321]
SOUTH	equ	[bp+322]
SEAST	equ	[bp+323]

vonn3	proc	far

	mov	dx,320		; load row length counter
	mov	cl,3		; load shift count

ocbyte: mov	al,SOUTH
	rol	al,1
	ror	ax,cl
	mov	al,EAST
	rol	al,1
	ror	ax,cl
	mov	al,WEST
	rol	al,1
	ror	ax,1
	ror	ax,1
	mov	bl,ah
	ror	ax,1
	mov	al,NORTH
	rol	al,1
	ror	ax,cl
	mov	al,SELF
	rol	al,1
	ror	ax,cl
	ror	ax,1
	mov	bh,ah

	mov	al,[bx] 	; load new value from lookup table
	inc	bp		; advance along row
	stosb			; store into new state table

	dec	dx		; more to update ?

	jnz	ocbyte		; yes.	keep on going

	ret
vonn3	endp

codes	ends
	end	vonn3
