/*

        Evaluator for the von Neumann neighbourhood with three
        bits of state visible from each neighbour and four
        bits of local state.  The value indexing the lookup
        table is:

                    mmmmnnnwwweeesss
        Self _________^  ^  ^  ^  ^ 
        North ___________|  |  |  |
        West _______________|  |  |
        East __________________|  |
        South ____________________|

                    by John Walker  --  March 1997

*/

#include <windows.h>

/*	If POINTERS is defined the evalUpdate function will use
	pointer arithmetic rather than array indexing to access
	the state vectors.  Depending on the compiler's optimiser,
	this may or may not be faster.  */

#define POINTERS

/*	If IULOOK is defined, conversions between internal
	(one bit rotated) and user states are done using a
	lookup table supplied in the file iu.h instead of
	in-line calculation.  Most evaluators run faster
	with IULOOK defined, but this can depend on the
	compiler, and interact with whether POINTERS is
	defined.  Experimentation is the only way to determine
	the optimal settings for your compiler and evalUpdate
	function definition.  */
	
#define IULOOK

#ifdef IULOOK
#include "iu.h"
#define ItoU(x)		itou[x]
#else
#define ItoU(x)     ((((x) << 1) | (((x) >> 7) & 1)) & 0xFF)
#endif

/*	Initialisation procedure  */

DWORD FAR PASCAL _export evalInit(HWND parentWindow,
		   						  int screenX, int screenY,
		   						  DWORD lutSize)
{
	return (DWORD) 0;
}

/*	Configuration procedure  */

void FAR PASCAL _export evalConfig(DWORD context, HWND parentWindow)
{
}		   							 

/*	Termination procedure  */

void FAR PASCAL _export evalTerm(DWORD context)
{
}		   							 

/*	Update map procedure  */

void FAR PASCAL _export evalUpdate(DWORD context,
								   LPBYTE oldvec, LPBYTE newvec, LPBYTE lut,
								   int torus, int auxval, long generation)
{
	unsigned int x, y;

#ifdef POINTERS

	/*	Pointer arithmetic version of evaluator.  */
	
	LPBYTE op, np;

#define NORTH	ItoU(*(op - 322))
#define WEST	ItoU(*(op - 1))
#define SELF 	ItoU(*op)
#define EAST	ItoU(*(op + 1))   
#define SOUTH	ItoU(*(op + 322))

#define NEWSELF	*np
    
    op = oldvec + 323;
    np = newvec + 323;
	for (y = 0; y < 200; y++) {
		for (x = 0; x < 320; x++) {
			unsigned int rv =
				 (SOUTH & 7) |
				((EAST & 7) << 3) |
				((WEST & 7) << 6) |
				((NORTH & 7) << 9) |
				((SELF & 15) << 12);
			
			/*	Lookup table entries are in internal bit order
				and can be stored directly into NEWSELF.  */
					
			NEWSELF++ = lut[rv];
			op++;
		}
		op += 2;
		np += 2;
	}

#else

	/* Array indexing version of evaluator.  */

#define NORTH	ItoU(oldvec[y * 322 + x + 1])
#define WEST	ItoU(oldvec[(y + 1) * 322 + x])
#define SELF 	ItoU(oldvec[(y + 1) * 322 + x + 1])
#define EAST	ItoU(oldvec[(y + 1) * 322 + x + 2])   
#define SOUTH	ItoU(oldvec[(y + 2) * 322 + x + 1])

#define NEWSELF	newvec[(y + 1) * 322 + x + 1]

	for (y = 0; y < 200; y++) {
		for (x = 0; x < 320; x++) {
			unsigned int rv =
				 (SOUTH & 7) |
				((EAST & 7) << 3) |
				((WEST & 7) << 6) |
				((NORTH & 7) << 9) |
				((SELF & 15) << 12);
			
			/*	Lookup table entries are in internal bit order
				and can be stored directly into NEWSELF.  */
					
			NEWSELF = lut[rv];
		}
	}
#endif	
}						

/*	Library initialisation  */

int FAR PASCAL LibMain(HINSTANCE hInstance, WORD wDataSeg, WORD wHeapSize,
					   LPSTR lpszCmdLine)
{
	if (wHeapSize > 0) {
		UnlockData(0);
	}
	return 1;
}					  

/*	Library termination handler  */

int FAR PASCAL _export WEP(int nParam)
{
	return 1;
}

