PROGRAM Aurora;
{A one dimensional rule with two neighbors, and 4 bits of each
  nieghbor visible.  This is run as a sixteen state rule, where
  NewC = (L + OldC + R)/3  +1.}
USES CaMake;
{$F+}	  { Required for function argument to genrule. }

FUNCTION CaRule(OldState,L3,L2,L1,L0,Self,R3,R2,R1,R0:integer):integer;
VAR
  L,C,R,Average:integer;
BEGIN
  { Develop 4 bit values of neighbours. }
  L := (((((l3 SHL 1) OR l2) SHL 1) OR l1) SHL 1) OR l0;
  R := (((((r3 SHL 1) OR r2) SHL 1) OR r1) SHL 1) OR r0;
  C := OldState AND 15;
  Average:=(L+C+R)DIV 3;
  CaRule:=Average+1;
END;

BEGIN {Main}
    WorldType := 9;	       {  World type:  2 neighbour ring }
    PalReq:='Aurora';
    RSeedB:=0;
    RSeedN:=4;
    GenRule(CaRule);
END.

