PROGRAM Axons;
{A one dimensional rule that only looks at one bit of two neighbors.
  We run it as WorldType 2, which gets one bit from each of 8 neighbors.
  The rule is totalistic, meaning that it only looks at the SUM of its
  neighborhood. The rule is also reversible, meaning that it saves
  its past state and XORs its calculated new state with the past
  state.  A final fillip to make this rule look good is that I use
  my extra six bits of state as a five bit clock and as a mask indicator.
  Whenever the clock counts up to 31, I turn on the bits where mask is
  on.  The start pattern for this consists of two dots with bit #0 turned
  on, all the times set to 0, and a pair of dots with mask set to 1.  You
  can vary the constant WolfCode to get other pictures.}
USES CaMake;
{$F+}	  { Required for function argument to genrule. }
FUNCTION CaRule(OldState,LLLL,LLL,LL,L,Self,R,RR,RRR,RRRR:integer):integer;
{This world type has variables for a cell and its eight nearest neighbors.
 This rule actually only uses L,C, and R, but we  write it for the other
 variables so that this program can be used as a template for
 WorldType 2 & 3 programs that do use eight one-bit neighbors.}
Const
  WolfCode=178;
VAR
 Sum,PastSelf,NewSelf,NewState,Time,Mask:integer;
BEGIN
  Sum:=(L+Self+R);
  PastSelf:=(OldState SHR 1) AND 1;
  NewSelf:=(WolfCode SHR Sum) AND 1;
  NewState:=(Self SHL 1) OR (NewSelf XOR PastSelf);
  Time:=(OldState SHR 2) AND 31;
  Mask:=(OldState SHR 7) AND 1;
  IF Time=31 THEN CaRule:=(Mask SHL 7) OR (NewState) OR Mask
	     ELSE CaRule:=(Mask SHL 7) OR ((Time+1)SHL 2) OR (NewState)
END;

BEGIN {Main}
    WorldType := 3;	       {  World type:  8 neighbour ring }
    PalReq:= 'Mask3';           {Only show low two bits}
    PatReq:= 'Axons';
    GenRule(CaRule);
END.
