PROGRAM Bob;
{This is modelled on the Hodgepodge rule of Gerhardt and Schuster,
 but is not a close enough model to produce a Zhabotinsky reaction
 except after extremely long run times.

 The start pattern used is the Shroud of Turing visage of "Bob".
 Bob is the High Epopt of the Church of the SubGenius.
 For more information about Bob and the Church, send $1 and a
 long stamped self-addressed envelope to:

 The SubGenius Foundation
 Box 140306
 Dallas, TX 75214

 The image of Bob is a registered trademark of the Church of the
 Subgenius and is used by special arrangement with Douglas
 St. Claire Smith, a.k.a. Ivan Stang.  Inquiries about further
 usage of Bob's image should be directed to Mr. Smith c/o The
 SubGenius Foundation.}

USES Camake;
{$F+}	  { Required for function argument to genrule. }
FUNCTION Carule(Oldstate,NW,N,NE,W,Self,E,SW,S,SE:integer):integer;
{The odd states are thought of as infected states.  A cell in state
 zero enters an infected state if it has any infected neighbors.
 An infected cell becomes more infected until its state exceeds 129,
 at which time it drops back to 0.}
VAR
  EightSum,Sickness,NewState:integer;
BEGIN  {Function}
  EightSum:=NW+N+NE+E+SE+S+SW+W;
  IF OldState=0
    THEN IF EightSum=0 THEN NewState:=0
		       ELSE NewState:=EightSum OR 1
    ELSE
      BEGIN
	Sickness:=OldState SHR 1;
	IF Sickness=64
	THEN NewState:=0
	ELSE
	  BEGIN
	    Sickness:=Sickness+EightSum+3;
	    IF Sickness>64 THEN Sickness:=64;
	    NewState:=(Sickness SHL 1) OR 1
	  END
       END;
  CaRule:=NewState
END;  {Function}
BEGIN {Main}
  PatReq:='Bob';
  PalReq:='Bob';
  GenRule(CaRule)
END.  {Main}
