PROGRAM BraiLife;
{This rule runs Life and Brain in parallel and lets them interact
 only within a certain masked region.  In this region, firing Brain cells
 turn on Life cells, and firing Life cells keep Brain cells from turning
 on.}
USES Camake;

{$F+}	  { Required for function argument to genrule. }

FUNCTION CaRule(Oldstate,NW,N,NE,W,Self,E,SW,S,SE:integer):integer;
{We use the eight bits of state as follows:
 Bit #0 is used to show either the Brain or the Life bit to neighbors;
 Bit #1 is the Life bit,
 Bit #2 is the firing Brain bit,
 Bit #3 is the refractory Brain bit,
 Bit #4 is the mask bit,and
 Bit #7 is the cycle bit.}
VAR
  L,NewL,B,NewB,BR,NewBR,Mask,Cycle,NewCycle,EightSum: integer;
BEGIN
  Cycle:=(OldState SHR 7) AND 1;
  Mask:= (OldState SHR 4) AND 1;
  BR:=	 (OldState SHR 3) AND 1;
  B:=	 (OldState SHR 2) AND 1;
  L:=	 (OldState SHR 1) AND 1;
  EightSum:=NW+N+NE+E+SE+S+SW+W;
  IF Cycle=0 THEN	{This is the update Life cycle}
    BEGIN
      {The Life rule}
      IF (EightSum=3)OR((EightSum=2)AND(L=1)) THEN NewL:=1 ELSE NewL:=0;
      {Turned on by firing Brain cells within region of mask}
      IF (Mask=1)AND(B=1) THEN NewL:=1;
      NewCycle:=1;
      CaRule:=(NewCycle SHL 7) OR (Mask SHL 4) OR (BR SHL 3) OR
		     (B SHL 2) OR (NewL SHL 1)	  OR B
    END;
  IF Cycle=1 THEN	{This is the update Firing cycle}
    BEGIN
      {The Brain rule}
      IF ((BR=0)AND(B=0))AND(EightSum=2)THEN NewB:=1 ELSE NewB:=0;
      {Turned off by firing Life cells within region of mask}
      IF (L=1)AND(Mask=1) THEN NewB:=0;
      NewBR:=B;
      NewCycle:=0;
      CaRule:=(NewCycle SHL 7) OR (Mask SHL 4)	OR (NewBR SHL 3) OR
		  (NewB SHL 2) OR (L SHL 1) OR L
    END
END;

BEGIN		 {Main program}
  {The BraiLife.CAC palette looks at bits 4,3,2, & 1.  Practically every
   combo has a meaning, so suppose I get my palette simply by disabling
   planes 0,5,6,7}
   PalReq:='BraiLife';
  {The starting BraiLife pattern has all bit 7s set to 0 (for synchronized
   cycles), has two adjacent cells on in plane #2 turned on to start Brain,
   and has a big disk mask in plane 4.}
  PatReq:='BraiLife';
  GenRule(CaRule);
END.

