{       Brian's Brain, discovered by Brian Silverman.

	(Toffoli & Margolus, section 6.1, page 47)

	Each cell has three states, though only one bit of the state
	is used to determine whether neighbours are on or off.	The
	rule is as follows:

	Old cell state	     New state

	  0 (Ready)		1 if exactly 2 neighbours in state 1,
				0 otherwise.
	  1 (Firing)		2
	  2 (Refractory)	0

    This can be though of as simulating the action of neurons which
    are insensitive to stimuli for some time after they fire.
}

program brain;

uses camake;

{$F+}	  { Required for function argument to genrule. }

function carule(oldstate,     nw, n  , ne,
			      w, self, e,
			      sw, s  , se : integer
	       ) : integer;
var
    count: 0 .. 9;
begin
	count := nw + n + ne + w + self + e + sw + s + se;

	if oldstate = 2 then	   { If in refractory state...	     }
	   carule := 0		   { ...become ready.		     }
	else if oldstate = 1 then  { If firing...		     }
	   carule := 2		   { ...go to refractory state.      }
	else begin		   { If ready...		     }
	   if count = 2 then	   { ...and two neighbours firing... }
	      carule := 1	   { ...then fire...		     }
	   else
	      carule := 0	   { ...otherwise stay ready.	     }
	end
end;

{  Main program. }

begin
    worldtype := 1;	       {  World type:  1 = torus
					       0 = open
					      -1 = unspecified	}

    randdens := 0;	       {  Random number plane enable
				  and density specification:
				    0	  = disable random plane
				  1 : 255 = likelihood of random firing
				   -1	  = unspecified  }

    auxplane := 0;	       {  Auxiliary plane configuration:
				   -1 = Unspecified
				    0 = Defined by rule or unused
				    1 = Temporal phase
				    2 = Horizontal texture
				    4 = Vertical texture
			      hence 6 = Checkerboard texture  }

    genrule(carule);
end.
