PROGRAM Dendrite;
{Diffuse with dendrite accretion.}
{Note that Diffuse needs randomizer set to 50% ones,}
{and that Dendrite needs a frozen pattern in plane 7 to accrete to, and}
{an initial gas pattern gas in plane 0.}
{We use plane #0 to show bits for updating.
{We use planes #1,2,3 for randomizer info.  We don't use plane #4.}
{We use plane #5 for the phase:}
{If bit #5 is 0 we update the gas motion,}
{If bit #5 is 1 we update the accretion,}
{We use #6 to indicate frozen cells:}
{If bit #6 is 0 we assume the cell is not frozen,}
{If bit #6 is 1 we assume the cell is frozen.}
{We use #7 to indicate presence of gas.}
{When running the rule use F8 to load the Dendrite palette which shows}
{states as white, red, or black depending as the high two bits are}
{10,01,or anything else, respectively.}

USES Camake;
{$F+}	  { Required for function argument to genrule. }
FUNCTION Carule(Oldstate,NW,N,NE,W,Self,E,SW,S,SE:integer):integer;
VAR
  FPhase,NewState,Direction,NewSelf,EightSum,Swap:integer;
BEGIN  {Function}
  NewState:=(OldState SHL 1) AND $0C; {Save two random bits}
  NewState:=NewState OR (OldState AND $C0); {Show two color bits}
  FPhase:=(OldState AND $60) SHR 5;
   CASE FPhase OF
  0:  BEGIN   {Not frozen, update gas}
	Direction:=((OldState AND $E) SHR 1);
	CASE Direction OF
	  0:  NewSelf:=NW;
	  1:  NewSelf:=N;
	  2:  NewSelf:=NE;
	  3:  NewSelf:=E;
	  4:  NewSelf:=SE;
	  5:  NewSelf:=S;
	  6:  NewSelf:=SW;
	  7:  NewSelf:=W;
	END;
	NewState:=NewState AND $7F; {Turn off gas bit}
	NewState:=NewState OR (NewSelf SHL 7); {Set gas}
	{Show a zero frozen frozen bit}
	NewState:=NewState OR $20; {Set phase to 1}
      END;
  1:  BEGIN  {Not frozen, update accrete}
	EightSum:=NW+N+NE+E+SE+S+SW+W;
	IF ((EightSum<>0) AND ((OldState AND $80)<>0))
	  THEN NewState:=$40 {Frozen, phase zero, shown no gas}
	  ELSE NewState:=NewState OR ((OldState AND $80)SHR 7);{Show gas bit}
	{Phase bit is already 0}
      END;
  2:  BEGIN  {Frozen, update gas}
	NewState:=$61; {Stay frozen, set phase to 1,show frozen}
      END;
  3:  BEGIN  {Frozen, update accrete}
	NewState:=$40;	{Stay frozen, set phase to zero,show no gas}
      END;
  END;
CaRule:=NewState
END;  {Function}

BEGIN {Main}
  patreq := 'dentim';
  palreq := 'dendrite';
  randb := 1;
  randn := 1;
  GenRule(CaRule)
END.  {Main}

