PROGRAM EcoLiBra;
{This rule runs Brain in the sea and AntiLife on land.	Six or seven
 firing Brain cells turn a sea cell into land.  Seven "antifiring" Antilife
 cells turn a land cell into sea.}
USES Camake;
{$F+}	  { Required for function argument to genrule. }

FUNCTION Carule(Oldstate,NW,N,NE,W,Self,E,SW,S,SE:integer):integer;
{Here rather than thinking of bits, we think of state numbers.
State 0 is dead sea
State 1 is firing brain in sea
State 2 is refractory brain in sea
State 3 is dead land
State 4 is firing life on land}
VAR
  EightSum,NewState:integer;
BEGIN  {Function}
  EightSum:=NW+N+NE+E+SE+S+SW+W;
  IF odd(OldState) THEN NewState:=3 ELSE NewState:=0;
  IF OldState=0 THEN
    CASE EightSum OF
      2: NewState:=1;
      6,7: NewState:=3;
      ELSE NewState:=0;
    END;
  IF OldState=1 THEN NewState:=2;
  IF OldState=2 THEN NewState:=0;
  IF OldState=3 THEN
    CASE EightSum OF
      5: NewState:=4;
      1: NewState:=0;
      ELSE NewState:=3;
    END;
  IF OldState=4 THEN
    CASE EightSum OF
      5,6: NewState:=4;
      ELSE NewState:=3
    END;
  CaRule:=NewState
END;  {Function}

BEGIN {Main}
  PalReq:='Default';
  PatReq:='EcoLiBra';
  GenRule(CaRule)
END.  {Main}

