PROGRAM Gyre;
{Rule suggested by William Gosper.  We lay down a mask marking
 the cartesian plane's four quadrants (Qs for short) by the numbers 0-3 in
 the arrangement    2  0
		    3  1.
 And we tell Q0 cells to copy SE, Q1 copy SW, Q2 copy NE, Q3 copy NW.
 A block of cell stuff will refract.}
USES Camake;
{$F+}	  { Required for function argument to genrule. }
FUNCTION Carule(OldState,NW,N,NE,W,Self,E,SW,S,SE:integer):integer;
VAR
  Barrier,Quadrant,NewSelf:integer;
BEGIN  {Function}
  Barrier:=(OldState SHR 3) AND 1;
  Quadrant:=(OldState SHR 1) AND 3;
  {Barrier cells stay barrier cells}
  IF Barrier=1 THEN CaRule:=8 ELSE
  BEGIN
    CASE Quadrant OF
      0: NewSelf:=SE;
      1: NewSelf:=SW;
      2: NewSelf:=NE;
      3: NewSelf:=NW;
    END;
    CaRule:=(Quadrant SHL 1) OR NewSelf;
  END;
END;  {Function}
BEGIN {Main}
  WorldType:=0; 	   {No wrap}
  PalReq:='Gyre';       {Colorful}
  {The pattern has Q's marked in bits 1,2 and a rectangle
   of food cells in Q0.  Pattern also has a frame of Barrier
   cells around the screen edge.}
  PatReq:='Gyre';
  GenRule(CaRule)
END.  {Main}
