PROGRAM HeatInc;
{Like Heat, this is the eightcell averaging rule run with certain cells fixed
 at certain "temperatures".  We use low bit to signal "leave alone."
 and force all other states to be even.  Unlike the Heat rule, we
 increment the average by 2.}
USES Camake;
{$F+}	  { Required for function argument to genrule. }
FUNCTION Carule(Oldstate,NW,N,NE,W,Self,E,SW,S,SE:integer):integer;
{OldState only has five bits, so ranges from 0 to 31.  We want to
store high and low values in OldState, so we will regard odd OldStates
1 - 15 as frozen at lowstates 1-15, and we will think of odd
OldStates 17-31 as frozen at 224+17 - 224+31.  224 = 11100000b, so for
the low five bits, 31 is the same as 224+31.}

BEGIN  {Function}
  IF (OldState AND 1)=1
   THEN IF OldState<16 THEN CaRule:=OldState
		       ELSE CaRule:=224+OldState
   ELSE CaRule:=((NW SHR 3)+2)AND 254;
END;  {Function}
BEGIN {Main}
  PalReq:='Autocad';
  WorldType:=10;
  GenRule(CaRule)
END.  {Main}
