{

        Langton's self-reproducing rule.  The rule definition must
	be used in conjunction with the LANGTON own-code evaluator.

}

program Langton;

uses Camake;
{$F+}	  { Required for function argument to genrule. }

type
	lutp = array[0..255] of 0..255;

var
	lutpage: array[0..255] of ^lutp;

{  Store one value in the lookup table	}

procedure sltab(c, n, e, s, w, new : integer);
var
	luti: integer;
begin
	luti := (c SHL 12) OR (n SHL 9) OR (e SHL 6) OR
		(s SHL 3) OR w;
	lutpage[(luti SHR 8) AND 255]^[luti AND 255] := new * 2;
end;

{  Set a value for all rotations  }

procedure s(c, n, e, s, w, new : integer);
begin
	sltab(c, n, e, s, w, new);
	sltab(c, e, s, w, n, new);
	sltab(c, s, w, n, e, new);
	sltab(c, w, n, e, s, new);
end;

procedure initrule;
var
	i, j: integer;
begin
	for i := 0 to 255 do begin
	   New(lutpage[i]);
	   for j := 0 to 255 do begin
	      lutpage[i]^[j] := 0;
	   end
	end;

	s(0,0,0,0,1,2);
	s(0,0,0,0,6,3);
	s(0,0,0,0,7,1);
	s(0,0,0,1,1,2);
	s(0,0,0,1,2,2);
	s(0,0,0,1,3,2);
	s(0,0,0,2,1,2);
	s(0,0,0,2,6,2);
	s(0,0,0,2,7,2);
	s(0,0,0,5,2,5);
	s(0,0,0,6,2,2);
	s(0,0,0,7,2,2);
	s(0,0,1,0,2,2);
	s(0,0,2,1,2,5);
	s(0,0,2,3,2,2);
	s(0,0,5,2,2,2);
	s(0,1,2,3,2,1);
	s(0,1,2,4,2,1);
	s(0,1,2,5,2,5);
	s(0,1,2,6,2,1);
	s(0,1,2,7,2,1);
	s(0,1,2,7,5,1);
	s(0,1,4,2,2,1);
	s(0,1,4,3,2,1);
	s(0,1,4,4,2,1);
	s(0,1,4,7,2,1);
	s(0,1,6,2,5,1);
	s(0,1,7,2,2,1);
	s(0,1,7,2,5,5);
	s(0,1,7,5,2,1);
	s(0,1,7,6,2,1);
	s(0,1,7,7,2,1);
	s(0,2,5,2,7,1);
	s(1,0,0,0,1,1);
	s(1,0,0,0,6,1);
	s(1,0,0,0,7,7);
	s(1,0,0,1,1,1);
	s(1,0,0,1,2,1);
	s(1,0,0,2,1,1);
	s(1,0,0,2,4,4);
	s(1,0,0,2,7,7);
	s(1,0,0,5,1,1);
	s(1,0,1,0,1,1);
	s(1,0,1,1,1,1);
	s(1,0,1,2,4,4);
	s(1,0,1,2,7,7);
	s(1,0,2,0,2,6);
	s(1,0,2,1,2,1);
	s(1,0,2,2,1,1);
	s(1,0,2,2,4,4);
	s(1,0,2,2,6,3);
	s(1,0,2,2,7,7);
	s(1,0,2,3,2,7);
	s(1,0,2,4,2,4);
	s(1,0,2,6,2,6);
	s(1,0,2,6,4,4);
	s(1,0,2,6,7,7);
	s(1,0,2,7,2,7);
	s(1,0,5,4,2,7);
	s(1,1,1,1,2,1);
	s(1,1,1,2,2,1);
	s(1,1,1,2,4,4);
	s(1,1,1,2,5,1);
	s(1,1,1,2,6,1);
	s(1,1,1,2,7,7);
	s(1,1,1,5,2,2);
	s(1,1,2,1,2,1);
	s(1,1,2,2,2,1);
	s(1,1,2,2,4,4);
	s(1,1,2,2,5,1);
	s(1,1,2,2,7,7);
	s(1,1,2,3,2,1);
	s(1,1,2,4,2,4);
	s(1,1,2,6,2,1);
	s(1,1,2,7,2,7);
	s(1,1,3,2,2,1);
	s(1,2,2,2,4,4);
	s(1,2,2,2,7,7);
	s(1,2,2,4,3,4);
	s(1,2,2,5,4,7);
	s(1,2,3,2,4,4);
	s(1,2,3,2,7,7);
	s(1,2,4,2,5,5);
	s(1,2,4,2,6,7);
	s(1,2,5,2,7,5);
	s(2,0,0,0,1,2);
	s(2,0,0,0,2,2);
	s(2,0,0,0,4,2);
	s(2,0,0,0,7,1);
	s(2,0,0,1,2,2);
	s(2,0,0,1,5,2);
	s(2,0,0,2,1,2);
	s(2,0,0,2,2,2);
	s(2,0,0,2,3,2);
	s(2,0,0,2,4,2);
	s(2,0,0,2,6,2);
	s(2,0,0,2,7,2);
	s(2,0,0,3,2,6);
	s(2,0,0,4,2,3);
	s(2,0,0,5,1,7);
	s(2,0,0,5,2,2);
	s(2,0,0,5,7,5);
	s(2,0,0,7,2,2);
	s(2,0,1,0,2,2);
	s(2,0,1,1,2,2);
	s(2,0,1,2,2,2);
	s(2,0,1,4,2,2);
	s(2,0,1,7,2,2);
	s(2,0,2,0,2,2);
	s(2,0,2,0,3,2);
	s(2,0,2,0,5,2);
	s(2,0,2,0,7,3);
	s(2,0,2,1,2,2);
	s(2,0,2,1,5,2);
	s(2,0,2,2,1,2);
	s(2,0,2,2,2,2);
	s(2,0,2,2,7,2);
	s(2,0,2,3,2,1);
	s(2,0,2,4,2,2);
	s(2,0,2,4,5,2);
	s(2,0,2,5,5,2);
	s(2,0,2,6,2,2);
	s(2,0,2,7,2,2);
	s(2,0,3,1,2,2);
	s(2,0,3,2,1,6);
	s(2,0,3,2,2,6);
	s(2,0,3,4,2,2);
	s(2,0,4,2,2,2);
	s(2,0,5,1,2,2);
	s(2,0,5,2,1,2);
	s(2,0,5,2,2,2);
	s(2,0,5,5,2,1);
	s(2,0,5,7,2,5);
	s(2,0,6,2,2,2);
	s(2,0,6,7,2,2);
	s(2,0,7,1,2,2);
	s(2,0,7,2,2,2);
	s(2,0,7,4,2,2);
	s(2,0,7,7,2,2);
	s(2,1,1,2,2,2);
	s(2,1,1,2,6,1);
	s(2,1,2,2,2,2);
	s(2,1,2,2,4,2);
	s(2,1,2,2,6,2);
	s(2,1,2,2,7,2);
	s(2,1,4,2,2,2);
	s(2,1,5,2,2,2);
	s(2,1,6,2,2,2);
	s(2,1,7,2,2,2);
	s(2,2,2,2,7,2);
	s(2,2,2,4,4,2);
	s(2,2,2,4,6,2);
	s(2,2,2,7,6,2);
	s(2,2,2,7,7,2);
	s(3,0,0,0,1,3);
	s(3,0,0,0,2,2);
	s(3,0,0,0,4,1);
	s(3,0,0,0,7,6);
	s(3,0,0,1,2,3);
	s(3,0,0,4,2,1);
	s(3,0,0,6,2,2);
	s(3,0,1,0,2,1);
	s(3,0,2,5,1,1);
	s(4,0,2,2,2,1);
	s(4,0,2,3,2,6);
	s(4,0,3,2,2,1);
	s(5,0,0,0,2,2);
	s(5,0,0,2,1,5);
	s(5,0,0,2,2,5);
	s(5,0,0,2,3,2);
	s(5,0,0,2,7,2);
	s(5,0,2,0,2,2);
	s(5,0,2,1,2,2);
	s(5,0,2,1,5,2);
	s(5,0,2,2,4,4);
	s(5,0,2,7,2,2);
	s(5,1,2,1,2,2);
	s(5,1,2,4,2,2);
	s(5,1,2,7,2,2);
	s(6,0,0,0,1,1);
	s(6,0,0,0,2,1);
	s(6,1,2,1,2,5);
	s(6,1,2,1,3,1);
	s(6,1,2,2,2,5);
	s(7,0,0,0,7,7);
	s(7,0,2,2,2,1);
	s(7,0,2,2,5,1);
	s(7,0,2,3,2,1);
	s(7,0,2,5,2,5);
end;

function carule(oldstate, nw, n, ne, w, self, e, sw, s, se :integer): integer;
begin
	carule := lutpage[(oldstate SHR 8) AND 255]^[oldstate AND 255];
end;

begin
	worldtype := 13;	   { Own code torus }
        patreq := 'langton';
        palreq := 'langton';
        ocodereq := 'langton';
	initrule;
	genrule(carule)
end.
