PROGRAM PerfumeX;
{This rule implements the Margolus XGas (HPPGas) rule for simulating
 particles bouncing off each other.  No external noise is used. Particles
 are regarded as travelling diagonally.  We set up a lattice
 of position values that looks like this:
		  0 1 0 1 ..
				       2 3 2 3 ..
				       0 1 0 1 ..
				       2 3 2 3 ..
				       : : : :
  This lattice is alternately chunked into
	 A blocks 0 1	and  B blocks 3 2
		  2 3		      1 0
  There is a collision, if that block has form	 1 0   or 0 1
						 0 1	  1 0.
  The XGas rule says: If there is a collision copy your clockwise neighbor,
   and if there is no collision copy your opposite corner.  Do the same
  thing in both lattice phases.}

USES Camake;

{$F+}	  { Required for function argument to genrule. }

FUNCTION CaRule(Oldstate,NW,N,NE,W,Self,E,SW,S,SE:integer):integer;
{We use the eight bits of state as follows:
 Bit   #0 is the machine visible bit for update
 Bit   #1 is used for the gas
 Bit   #2 is the wall
 Bit   #3 is the touch wall in my neighborhood bit
 Bits  #4 & #5 hold a position number between 0 and 3
 Bit   #6 controls the check wall/do gas cycle
 Bit   #7 controls the A/B lattice cycle}
VAR
  Cycle,NewCycle,Position,TouchWall,NewTouchWall,Wall,Gas,NewGas,
  NewSelf:integer;
  Collision:boolean;
BEGIN
  Cycle:=(OldState SHR 6) AND 3;
  Position:=(OldState SHR 4) AND 3;
  TouchWall:=(OldState SHR 3) AND 1;
  Wall:=(OldState SHR 2) AND 1;
  Gas:=(OldState SHR 1) AND 1;

  NewCycle:=(Cycle + 1)MOD 4;
  {In both Cycle0/LatticeA and Cycle1/LatticeB do}
  {IF Collsion THEN NewSelf:=CW ELSE NewSelf:=OPP}
  IF Cycle=0 THEN      {Set touch wall if any neighbor is on}
		       {Block has form 0 1
				       2 3}
    BEGIN
      CASE Position OF
	0: IF (Self+E+SE+S)<>0 THEN NewTouchWall:=1 ELSE NewTouchWall:=0;
	1: IF (Self+S+SW+W)<>0 THEN NewTouchWall:=1 ELSE NewTouchWall:=0;
	2: IF (Self+N+NE+E)<>0 THEN NewTouchWall:=1 ELSE NewTouchWall:=0;
	3: IF (Self+W+NW+N)<>0 THEN NewTouchWall:=1 ELSE NewTouchWall:=0;
      END;
      NewGas:=Gas;
      NewSelf:=Gas;
    END;
  IF Cycle=1 THEN	   {Move gas unless collision or TouchWall}
  {Block has form 0 1
		  2 3}
    BEGIN
      CASE Position OF
	0: BEGIN
	     Collision:=(Self=SE)AND(E=S);
	     IF Collision OR (TouchWall=1) THEN NewGas:=E ELSE NewGas:=SE;
	   END;
	1: BEGIN
	     Collision:=(Self=SW)AND(W=S);
	     IF Collision OR (TouchWall=1) THEN NewGas:=S ELSE NewGas:=SW;
	   END;
	2: BEGIN
	     Collision:=(Self=NE)AND(E=N);
	     IF Collision OR (TouchWall=1)THEN NewGas:=N ELSE NewGas:=NE;
	   END;
	3: BEGIN
	     Collision:=(Self=NW)AND(W=N);
	     IF Collision OR (TouchWall=1)THEN NewGas:=W ELSE NewGas:=NW;
	   END;
      END;
      NewTouchWall:=TouchWall;
      NewSelf:=Wall;
  END;
  IF Cycle=2 THEN      {Set touch wall if any neighbor is on}
		       {Block has form 3 2
				       1 0}
    BEGIN
      CASE Position OF
	0: IF (Self+W+NW+N)<>0 THEN NewTouchWall:=1 ELSE NewTouchWall:=0;
	1: IF (Self+N+NE+E)<>0 THEN NewTouchWall:=1 ELSE NewTouchWall:=0;
	2: IF (Self+S+SW+W)<>0 THEN NewTouchWall:=1 ELSE NewTouchWall:=0;
	3: IF (Self+E+SE+S)<>0 THEN NewTouchWall:=1 ELSE NewTouchWall:=0;
      END;
      NewGas:=Gas;
      NewSelf:=Gas;
    END;
  {IF Collison NewSelf:=CW ELSE NewSelf:=OPP}
  IF Cycle=3 THEN
  {Block has form 3 2
		  1 0}
    BEGIN
      CASE Position OF
	0: BEGIN
	     Collision:=(Self=NW)AND(W=N);
	     IF Collision OR(TouchWall=1) THEN NewGas:=W ELSE NewGas:=NW;
	   END;
	1: BEGIN
	     Collision:=(Self=NE)AND(E=N);
	     IF Collision OR(TouchWall=1) THEN NewGas:=N ELSE NewGas:=NE;
	   END;
	2: BEGIN
	     Collision:=(Self=SW)AND(W=S);
	     IF Collision OR (TouchWall=1)THEN NewGas:=S ELSE NewGas:=SW;
	   END;
	3: BEGIN
	     Collision:=(Self=SE)AND(E=S);
	     IF Collision OR (TouchWall=1)THEN NewGas:=E ELSE NewGas:=SE;
	   END;
      END;
      NewTouchWall:=TouchWall;
      NewSelf:=Wall
   END;
 CaRule:=(NewCycle SHL 6)OR(Position SHL 4)OR(NewTouchWall SHL 3)
	 OR (Wall SHL 2) OR (NewGas SHL 1)OR NewSelf;
END;

BEGIN		 {Main program}
    {We set a horizontal pattern of alternate 0s and 1s in bit 4
     and a vertical pattern of alternate 0s and 1s in bit 5.
     This produces a pattern that goes 0 1 0 1 ..
				       2 3 2 3 ..
				       0 1 0 1 ..
				       2 3 2 3 ..
				       : : : :	      }
  texthb:=4;
  texthn:=1;
  textvb:=5;
  textvn:=1;
    {The Mask2.CAC palette only shows bit 1 (hex mask 2)}
  PalReq:='Perfume';
    {The starting Perfume pattern is wall around a glob of gas}
  PatReq:='Perfume';
  GenRule(CaRule);
END.
