PROGRAM Pond;
{This rule implements two independent copies of TGas (TMGas) at the same time,
 producing two interpenetrating gases.	See XTC.Pas for more about TGas.
 The point of this rule is to show a "sound wave".}

USES Camake;

{$F+}	  { Required for function argument to genrule. }

FUNCTION CaRule(Oldstate,NW,N,NE,W,Self,E,SW,S,SE:integer):integer;
{We use the eight bits of state as follows:
 Bit   #0 is the machine visible bit for update
 Bit   #1 is T gas (vertical/horizontal)
 Bit   #2 is X gas (diagonal)
 Bit   #3 is reserved for a self-erasing startup mask
 Bits  #4 & #5 hold a position number between 0 and 3
 Bit   #6 and #7 control the cycle.
       In cycle 0 we update the  T gas in lattice A.
       In cycle 1 we update the  T gas in lattice B.
       In cycle 2 we update the  X gas in lattice A.
       In cycle 3 we update the  X gas in lattice B.}
VAR
  Cycle,NewCycle,Position,Hole,TGas1,TGas0,NewSelf,NewState:integer;
  Collision:boolean;
BEGIN
  Cycle:=(OldState SHR 6) AND 3;
  Position:=(OldState SHR 4) AND 3;
  {For all the gas updates we simply calculate NewSelf
   and worry about where to store them below}

  IF (Cycle=0)OR(Cycle=2) THEN	    {TGas A.  Rotate CCW if no collision}
    CASE Position OF
      0: BEGIN
	   Collision:=(Self=SE)AND(E=S);
	   IF NOT(Collision) THEN NewSelf:=E ELSE NewSelf:=Self;
	 END;
      1: BEGIN
	   Collision:=(Self=SW)AND(W=S);
	   IF NOT(Collision) THEN NewSelf:=S ELSE NewSelf:=Self;
	 END;
      2: BEGIN
	   Collision:=(Self=NE)AND(E=N);
	   IF NOT(Collision) THEN NewSelf:=N ELSE NewSelf:=Self;
	 END;
      3: BEGIN
	   Collision:=(Self=NW)AND(W=N);
	   IF NOT(Collision) THEN NewSelf:=W ELSE NewSelf:=Self;
	 END;
    END;
  IF (Cycle=1)OR(Cycle=3) THEN	    {TGas B.  Rotate CW if no collision}
    CASE Position OF
      0: BEGIN
	   Collision:=(Self=NW)AND(W=N);
	   IF NOT(Collision) THEN NewSelf:=N ELSE NewSelf:=Self;
	 END;
      1: BEGIN
	   Collision:=(Self=NE)AND(E=N);
	   IF NOT(Collision) THEN NewSelf:=E ELSE NewSelf:=Self;
	 END;
      2: BEGIN
	   Collision:=(Self=SW)AND(W=S);
	   IF NOT(Collision) THEN NewSelf:=W ELSE NewSelf:=Self;
	 END;
      3: BEGIN
	   Collision:=(Self=SE)AND(E=S);
	   IF NOT(Collision) THEN NewSelf:=S ELSE NewSelf:=Self;
	 END;
    END;
TGas0:=(OldState SHR 1) AND 1;
TGas1:=(OldState SHR 2) AND 1;
Hole:=(OldState SHR 3) AND 1;
NewCycle:=(Cycle+1)MOD 4;
NewState:=(NewCycle SHL 6)OR(Position SHL 4); {This is just the easy stuff}
IF Hole=1 THEN CARule:=(NewState OR 7) ELSE
  CASE Cycle OF
    0:	{TGas0 was updated.  Make TGas0 visible for next}
	CaRule:=NewState OR (TGas1 SHL 2) OR (NewSelf SHL 1) OR NewSelf;
    1:	{TGas0 was updated.  Make TGas1 visible for next}
	CaRule:=NewState OR (TGas1 SHL 2) OR (NewSelf SHL 1) OR TGas1;
    2:	{X Gas was updated.  Make X visible for next}
	CaRule:=NewState OR (NewSelf SHL 2) OR (TGas0 SHL 1) OR NewSelf;
    3:	{X Gas was updated.  Make T visible for next}
	CaRule:=NewState OR (NewSelf SHL 2) OR (TGas0 SHL 1) OR TGas0;
  END

END;

BEGIN		 {Main program}
    {We set a horizontal pattern of alternate 0s and 1s in bit 4
     and a vertical pattern of alternate 0s and 1s in bit 5.
     This produces a pattern that goes 0 1 0 1 ..
				       2 3 2 3 ..
				       0 1 0 1 ..
				       2 3 2 3 ..
				       : : : :	      }
  texthb:=4;
  texthn:=1;
  textvb:=5;
  textvn:=1;
  {seed thick gas into planes 0,1,and 2. 1 will be overwritten by 0 after
   1 cycle}
  rseedp:=255;
  rseedb:=0;
  rseedn:=3;
    {The Pond.CAC palette shows white iff bit 1 AND 2 are on}
  PalReq:='Pond';
    {The starting Pond pattern is a hole marked by 1s in plane 3
     This nukes out a hole in the start gas at first cycle and
     disappears.  I do such contortions to make Pond.CAP small.}
  PatReq:='Pond';
  GenRule(CaRule);
END.
