PROGRAM Ranch;
{This rule alterantes cycles of Vote and Brain/Vote}
{The boundary is treated differently on the land side.}
USES Camake;

{$F+}	  { Required for function argument to genrule. }

FUNCTION CaRule(Oldstate,NW,N,NE,W,Self,E,SW,S,SE:integer):integer;
{We use the eight bits of state as follows:
 Bit #0 is used to show either the firing or the vote bit to neighbors;
 Bit #1 is the firing bit, Bit #2 is the refractory bit, Bit #3 is the
 Vote bit, Bit #4 is the vote memory bit, and Bit #7 is the cycle bit.}
VAR
  Cycle,M,V,R,F,EightSum,NineSum,NewCycle,NewM,NewV,NewR,NewF: integer;
BEGIN
  Cycle:=(OldState SHR 7) AND 1;
  M:=	 (OldState SHR 4) AND 1;
  V:=	 (OldState SHR 3) AND 1;
  R:=	 (OldState SHR 2) AND 1;
  F:=	 (OldState SHR 1) AND 1;
  EightSum:=NW+N+NE+E+SE+S+SW+W;
  NineSum:=EightSum+Self;
  IF Cycle=0 THEN	{This is the update Vote cycle}
    BEGIN
      IF (NineSum>5)OR(NineSum=4)THEN NewV:=1 ELSE NewV:=0;
      NewM:=V;
      NewCycle:=1;
      CaRule:=(NewCycle SHL 7) OR (NewM SHL 4) OR (NewV SHL 3) OR
		     (R SHL 2) OR (F SHL 1)    OR F
    END;
  IF Cycle=1 THEN	{This is the update Firing cycle}
    BEGIN
      IF V=0 THEN			  {Use Brain rule at sea}
	IF (R=0)AND(F=0)AND(EightSum=2) THEN NewF:=1 ELSE NewF:=0;
      IF (V=1) AND (M=1) THEN		  {Use Life rule inland}
	IF (EightSum=3)OR((F=1)AND(EightSum=2)) THEN NewF:=1 ELSE NewF:=0;
      IF (V=1) AND (M=0) THEN		  {Use EdgeLife on new land}
	IF (EightSum=1)OR(EightSum=4) THEN NewF:=1 ELSE NewF:=0;
      IF V=1 THEN NewR:=0 ELSE NewR:=F;   {Only sea cells can be refractory}
      NewCycle:=0;
      CaRule:=(NewCycle SHL 7) OR (M SHL 4)    OR (V SHL 3) OR
		  (NewR SHL 2) OR (NewF SHL 1) OR V
    END
END;

BEGIN		 {Main program}
  {The Ranch.CAC palette looks only at bits 3,2, & 1.  Pattern meanings:
   ----001- is firing at sea
   ----010- is refractory at sea
   ----1-0- is dead on land
   ----1-1- is live on land
   & others are dead at sea}
  PalReq:='Ranch';
  {The default sets all starting bit 7s set to 0 (for synchronized
   cycles), and we random seed Planes #0 and #1 to start Vote and firing}
  RSeedB:=0;
  RSeedN:=2;
  GenRule(CaRule);
END.
