PROGRAM ShortPi;
{A one dimensional rule that only looks at two bits of two neighbors.
  We run it as WorldType 5, which gets two bits from each of four neighbors.
  The rule is totalistic, meaning that it only looks at the SUM of its
  neighborhood. The first four digits of the totalistic lookup table
  are the first four digits of pi, taken MOD 4.  The next six digits
  were found by trial and error to make a rule that looks good.}
USES CaMake;
{$F+}	  { Required for function argument to genrule. }
FUNCTION CaRule(OldState,LL1,LL0,L1,L0,Self,R1,R0,RR1,RR0:integer):integer;
{We will define two-bit variables LL, L, C, R, and RR covering a
 cell and its four nearest neighbors.  This rule actually only uses
 L,C, and R, but we develop LL and RR so this program can be used as
 a template for WorldType 5 programs that do use four two-bit neighbors}

VAR
 LL,L,C,R,RR,Sum:integer;
BEGIN
{ Develop 2 bit values of neighbours.}
  LL:= 2*LL1 + LL0;
  L := 2*L1  + L0;
  C := OldState AND 3;
  R := 2*R1  + R0;
  RR:= 2*RR1 + RR0;

  Sum:=(L+C+R);
  CASE Sum OF
	0:  CaRule:=3;
	1:  CaRule:=1;
	2:  CaRule:=0;
	3:  CaRule:=1;
	4:  CaRule:=0;
	5:  CaRule:=3;
	6:  CaRule:=2;
	7:  CaRule:=0;
	8:  CaRule:=0;
	9:  CaRule:=0;
  END;
END;

BEGIN {Main}
    WorldType := 5;	       {  World type:  4 neighbour ring }
    GenRule(CaRule);
END.
