PROGRAM Soot;
{This rule uses the TGas ToffoliMargolus rule for simulating
 particles bouncing off each other.  No external noise is used. Particles
 are regarded as travelling horizontally or vertically.  We set up a lattice
 of position values that looks like this:
		  0 1 0 1 ..
				       2 3 2 3 ..
				       0 1 0 1 ..
				       2 3 2 3 ..
				       : : : :
  This lattice is alternately chunked into
	 A blocks 0 1	and  B blocks 3 2
		  2 3		      1 0
 There is a collision, if that is a block has form   1 0   or 0 1
						     0 1      1 0.
  The blocks are rotated one notch CCW in phase A & one notch
  CW  in phase B, EXCEPT when a block has form	 1 0   or 0 1
						 0 1	  1 0
  ,which is the Collision case. In the collision case, block stays same.

The gas particles are allowed to accrete on "wall" cells.}

USES Camake;

{$F+}	  { Required for function argument to genrule. }

FUNCTION CaRule(Oldstate,NW,N,NE,W,Self,E,SW,S,SE:integer):integer;
{We use the eight bits of state as follows:
 Bit   #0 is the machine visible bit for update
 Bit   #1 is used for the gas
 Bit   #2 is the wall
 Bit   #3 is unused
 Bits  #4 & #5 hold a position number between 0 and 3
 Bits	#6 & #7 control the check wall/do gas cycle
       If 0 do wall, if 1 do lattice A, if 2 do lattice B}

VAR
  EightSum,Cycle,NewCycle,Position,Wall,Gas,NewGas,NewSelf:integer;
  Collision:boolean;
BEGIN
  Cycle:=(OldState SHR 6) AND 3;
  Position:=(OldState SHR 4) AND 3;
  Wall:=(OldState SHR 2) AND 1;
  Gas:=(OldState SHR 1) AND 1;
  EightSum:=NW+N+NE+E+SE+S+SW+W;

  IF Cycle=0 THEN      {Check if you are touching wall}
    BEGIN
      IF (Gas=1)AND(EightSum>0) THEN
	BEGIN
	  Gas:=0;
	  Wall:=1
	END;
      NewGas:=Gas;
      NewSelf:=Gas;
      NewCycle:=1;
    END;

  IF Cycle=1 THEN	{TGas A.  Rotate CCW if no collision}
			{Block has form 0 1
					2 3}
  BEGIN
    CASE Position OF
      0: BEGIN
	   Collision:=(Self=SE)AND(E=S);
	   IF NOT(Collision ) THEN Newgas:=E
	      ELSE Newgas:=Self;
	 END;
      1: BEGIN
	   Collision:=(Self=SW)AND(W=S);
	   IF NOT(Collision ) THEN Newgas:=S
	       ELSE Newgas:=Self;
	 END;
      2: BEGIN
	   Collision:=(Self=NE)AND(E=N);
	   IF NOT(Collision ) THEN Newgas:=N
	      ELSE Newgas:=Self;
	 END;
      3: BEGIN
	   Collision:=(Self=NW)AND(W=N);
	   IF NOT(Collision ) THEN Newgas:=W
	       ELSE Newgas:=Self;
	 END;
    END;
    NewSelf:=Wall;
    NewCycle:=2;
  END;

    IF Cycle=2 THEN	 {Check if you are touching wall}
    BEGIN
      IF (Gas=1)AND(EightSum>0) THEN
	BEGIN
	  Gas:=0;
	  Wall:=1
	END;
      NewGas:=Gas;
      NewSelf:=Gas;
      NewCycle:=3;
    END;


 IF Cycle=3 THEN      {TGas A.	Rotate CW if no collision}
		      {Block has form 3 2
				      1 0}
    BEGIN
    CASE Position OF
      0: BEGIN
	   Collision:=(Self=NW)AND(W=N);
	   IF NOT(Collision ) THEN Newgas:=N
	      ELSE Newgas:=Self;
	 END;
      1: BEGIN
	   Collision:=(Self=NE)AND(E=N);
	   IF NOT(Collision ) THEN Newgas:=E
	      ELSE Newgas:=Self;
	 END;
      2: BEGIN
	   Collision:=(Self=SW)AND(W=S);
	   IF NOT(Collision ) THEN Newgas:=W
	      ELSE Newgas:=Self;
	 END;
      3: BEGIN
	   Collision:=(Self=SE)AND(E=S);
	   IF NOT(Collision ) THEN Newgas:=S
	       ELSE Newgas:=Self;
	 END;
    END;
      NewSelf:=Wall;
      NewCycle:=0;
   END;

 CaRule:=(NewCycle SHL 6)OR(Position SHL 4)OR
	 (Wall SHL 2) OR (NewGas SHL 1)OR NewSelf;
END;

BEGIN		 {Main program}
    {two-dimensional world with wrap}
    worldtype:=1;
    {We set a horizontal pattern of alternate 0s and 1s in bit 4
     and a vertical pattern of alternate 0s and 1s in bit 5.
     This produces a pattern that goes 0 1 0 1 ..
				       2 3 2 3 ..
				       0 1 0 1 ..
				       2 3 2 3 ..
				       : : : :	      }
  texthb:=4;
  texthn:=1;
  textvb:=5;
  textvn:=1;
  rseedp:=80;
  {seed plane 1 with random gas to start}
  rseedb:=1;
  rseedn:=1;
  {We use the "Perfume" palette which shows bits 1 and 2 only}
  PalReq:='Perfume';
    {The starting SloGro is a single wall cell in plane 2}
  PatReq:='Soot';
  GenRule(CaRule);
END.

