PROGRAM SoundCa;
{This is a CA implementation of one of the rules from the standalone
 SoundCa program from the RC disk.  SoundCa is a semitotalistic rule
 which looks at two bit each of a cell and its two neighbors.  Depending
 on what the center cell's state is, the cell reacts differently to
 the neighborhood sum.	This rule is meant to be used as a template,
 so that you can key in any SoundCa rule that interests you.}
USES CaMake; {$F+}
FUNCTION CaRule(OldState,LL1,LL0,L1,L0,Self,R1,R0,RR1,RR0:integer):integer;
{We will define two-bit variables L, C, and R.}
CONST
  RuleTable: ARRAY[0..13] OF integer=(
  {For a Sum of:	 6   5	 4   3	 2   1	 0}
  {States 0 and 3 use:}  3,  2,  1,  3,  1,  2,  0,
  {States 1 and 2 use:}  0,  1,  0,  3,  3,  1,  0  );
VAR
 L,C,R,Sum,Index:integer;
BEGIN
  L := 2*L1 + L0;
  C := OldState AND 3;
  R := 2*R1 + R0;
  Sum:=(L+R);
  CASE C OF
	0,3: Index:=6-Sum;
	1,2: Index:=13-Sum;
  END;
  CaRule:=RuleTable[Index]
END;

BEGIN {Main}
    WorldType := 5;	       {  World type:  4 neighbour ring }
    GenRule(CaRule);
END.
