PROGRAM Sublime;
{This rule implements the Margolus rule for simulating a gas of
 cells diffusing.  Particle number is conserved.  We set up a lattice
 of position values that looks like this:
		  0 1 0 1 ..
				       2 3 2 3 ..
				       0 1 0 1 ..
				       2 3 2 3 ..
				       : : : :
  This lattice is alternately chunked into
	 A blocks 0 1	and  B blocks 3 2
		  2 3		      1 0
  and the blocks are Noisely rotated one notch CW or one notch CCW}

USES Camake;

{$F+}	  { Required for function argument to genrule. }

FUNCTION CaRule(Oldstate,NW,N,NE,W,Self,E,SW,S,SE:integer):integer;
{We use the eight bits of state as follows:
 Bit  #0 is used to show info to neighbors
 Bit  #1 is the gas bit
 Bit  #2 is fed by the system Noiseizer
 Bit  #3 stores the 4-cell consensus on direction 0 is CCW, 1 is CW
 Bits #4 & #5 hold a position numbers between 0 and 3
 Bits #6 & #7 control the cycle}
VAR
  Cycle,NewCycle,Position,Direction,NewDirection,Noise,Gas,NewGas:integer;
BEGIN
  Cycle:=(OldState SHR 6) AND 3;
  Position:=(OldState SHR 4) AND 3;
  Direction:=(OldState SHR 3) AND 1;
  Noise:=(OldState SHR 2) AND 1;
  Gas:=(OldState SHR 1)AND 1;
  NewCycle:=(Cycle+1)MOD 4;
  IF (Cycle=0)OR(Cycle=2) THEN
    BEGIN
      IF Cycle=0 THEN      {In A block mode set direction to NW's}
	CASE Position OF
	  0: NewDirection:=Self;
	  1: NewDirection:=W;
	  2: NewDirection:=N;
	  3: NewDirection:=NW;
	END;
      IF Cycle=2 THEN      {In B block mode set direction to NW's}
	CASE Position OF
	  0: NewDirection:=NW;
	  1: NewDirection:=N;
	  2: NewDirection:=W;
	  3: NewDirection:=Self;
	END;
      CaRule:=(NewCycle SHL 6)OR(Position SHL 4)OR
	      (NewDirection SHL 3)OR(Gas SHL 1)OR Gas
    END
  ELSE
    BEGIN
     IF (Cycle=1) AND (Direction=0) THEN  {CCW rotation of an A block}
       CASE Position OF
	 0: NewGas:=E;
	 1: NewGas:=S;
	 2: NewGas:=N;
	 3: NewGas:=W;
       END;
     IF (Cycle=1) AND (Direction=1) THEN   {CW rotation of an A block}
       CASE Position OF
	 0: NewGas:=S;
	 1: NewGas:=W;
	 2: NewGas:=E;
	 3: NewGas:=N;
       END;
     IF (Cycle=3) AND (Direction=0) THEN   {CCW rotation of a B block}
       CASE Position OF
	 0: NewGas:=W;
	 1: NewGas:=N;
	 2: NewGas:=S;
	 3: NewGas:=E;
       END;
     IF (Cycle=3) AND (Direction=1) THEN    {CW rotation of an A block}
       CASE Position OF
	 0: NewGas:=N;
	 1: NewGas:=E;
	 2: NewGas:=W;
	 3: NewGas:=S;
       END;
      CaRule:=(NewCycle SHL 6)OR(Position SHL 4)OR
	      (Direction SHL 3)OR(NewGas SHL 1)OR Noise
    END;
END;

BEGIN		 {Main program}
    {We set bit #4 to be Noiseized each update}
  randb:=2;
  randn:=1;
    {We set a vertical pattern of alternate 0s and 1s in bit 4
     and a vertical pattern of alternate 0s and 1s in bit 5.
     This produces a pattern that goes 0 1 0 1 ..
				       2 3 2 3 ..
				       0 1 0 1 ..
				       2 3 2 3 ..
				       : : : :	      }
  texthb:=4;
  texthn:=1;
  textvb:=5;
  textvn:=1;
  rseedb:=0;
  rseedn:=1;
    {The Gas.CAC palette only shows bit 1}
  PalReq:='Sublime';
    {The starting Gas pattern is some geometric objects}
  PatReq:='Sublime';
  GenRule(CaRule);
END.
