PROGRAM TimeTun;
{This is based on the program Time-Tunnel in [Margolus&Toffoli87],p.52.
 In this rule a cell looks only at the low bits of itself and its
 N,E,W,S neighbors.  If all five cells have the same low bit, the cell
 decides to turn off with boredom, otherwise it has positive Interest.
 The "time tunnel" fillip of this rule is gotten by subtracting
 the cell's prior state from Interest.  Thus:
 NewSelf:=Interest(Self) - OldSelf.
 This equation is symmetric and can be rewritten:
 OldSelf:=Interest(Self) - NewSelf.
 The result of the symmetry is that the rule is reversible.  In order to
 keep track of OldSelf, I store it in bit #1.
 So if I press o and then s to tell CL to swap the present Self plane 0
 with the memory OldSelf plane 1, then the rule will run backwards to its
 start pattern, and then on into "negative time" (which looks the same).}
USES CaMake;
{$F+}	  { Required for function argument to genrule. }
FUNCTION CaRule(OldState,NW,N,NE,W,Self,E,SW,S,SE:integer):integer;
{Bit #0 is firing bit
{Bit #1 is memory bit}
VAR
  Interest,OldSelf,NewSelf,FiveSum: integer;
BEGIN
  OldSelf:=(OldState SHR 1) AND 1;
  FiveSum:=N+E+Self+S+W;
  IF (FiveSum=0)OR(FiveSum=5) THEN Interest:=0
			      ELSE Interest:=1;
  {Since I only have two states 0 and 1, I can avoid getting negative
   states by adding 2 before subtracting and evaluating MOD 2.
   Or I could simply have written NewSelf:=Interest XOR OldSelf.}
  NewSelf:=(2 + Interest - OldSelf) MOD 2;
  {Now store your present self in the OldSelf slot}
  OldSelf:=Self;
  CaRule:=(OldSelf SHL 1)OR NewSelf;
END;
BEGIN  {Main}
    PalReq:='Default';
    PatReq:='TimeTun';
    GenRule(CaRule);
END.
