PROGRAM Pond;
{This rule implements the Margolus rule for simulating a gas of
 particles bouncing off each other.  No external noise is used. Particles
 are regarded as travelling horizontally or vertically.  We set up a lattice
 of position values that looks like this:
		  0 1 0 1 ..
				       2 3 2 3 ..
				       0 1 0 1 ..
				       2 3 2 3 ..
				       : : : :
  This lattice is alternately chunked into
	 A blocks 0 1	and  B blocks 3 2
		  2 3		      1 0
  and the blocks are rotated one notch CCW in phase A & one notch CCW
  in phase B, EXCEPT when a block has form   1 0   or 0 1
					     0 1      1 0}

USES Camake;

{$F+}	  { Required for function argument to genrule. }

FUNCTION CaRule(Oldstate,NW,N,NE,W,Self,E,SW,S,SE:integer):integer;
{We use the eight bits of state as follows:
 Bit   #0 is the machine visible bit for update
 Bit   #1 is used for the gas
 Bit   #2 is reserved for second gas color
 Bit   #3 is reserved for signalling container walls
 Bits  #4 & #5 hold a position number between 0 and 3
 Bit   #6 is reserved to control a second gas color
 Bit   #7 controls the A/B lattice cycle}
VAR
  Cycle,NewCycle,Position,Wall,Gas1,Gas0,NewSelf:integer;
  Collision:boolean;
BEGIN
  Cycle:=(OldState SHR 7) AND 1;
  Position:=(OldState SHR 4) AND 3;
{  Wall:=(OldState SHL 3) AND 1;
  Gas1:=(OldState SHL 2) AND 1;
  Gas0:=(OldState SHL 1) AND 1;}
  NewCycle:=Cycle XOR 1;
  NewSelf:=Self;       {Assume there is a collision and thus no rotation}
  IF Cycle=0 THEN      {Rotate CCW if no collision}
    CASE Position OF
      0: BEGIN
	   Collision:=(Self=SE)AND(E=S);
	   IF NOT(Collision) THEN NewSelf:=E;
	 END;
      1: BEGIN
	   Collision:=(Self=SW)AND(W=S);
	   IF NOT(Collision) THEN NewSelf:=S;
	 END;
      2: BEGIN
	   Collision:=(Self=NE)AND(E=N);
	   IF NOT(Collision) THEN NewSelf:=N;
	 END;
      3: BEGIN
	   Collision:=(Self=NW)AND(W=N);
	   IF NOT(Collision) THEN NewSelf:=W;
	 END;
    END;
  IF Cycle=1 THEN      {Rotate CW if no collision}
    CASE Position OF
      0: BEGIN
	   Collision:=(Self=NW)AND(W=N);
	   IF NOT(Collision) THEN NewSelf:=N;
	 END;
      1: BEGIN
	   Collision:=(Self=NE)AND(E=N);
	   IF NOT(Collision) THEN NewSelf:=E;
	 END;
      2: BEGIN
	   Collision:=(Self=SW)AND(W=S);
	   IF NOT(Collision) THEN NewSelf:=W;
	 END;
      3: BEGIN
	   Collision:=(Self=SE)AND(E=S);
	   IF NOT(Collision) THEN NewSelf:=S;
	 END;
    END;
 CaRule:=(NewCycle SHL 7)OR(Position SHL 4)OR(NewSelf SHL 1)OR NewSelf;
END;

BEGIN		 {Main program}
    {We set a horizontal pattern of alternate 0s and 1s in bit 4
     and a vertical pattern of alternate 0s and 1s in bit 5.
     This produces a pattern that goes 0 1 0 1 ..
				       2 3 2 3 ..
				       0 1 0 1 ..
				       2 3 2 3 ..
				       : : : :	      }
  texthb:=4;
  texthn:=1;
  textvb:=5;
  textvn:=1;
    {The Mask2.CAC palette only shows bit 1 (hex mask 2)}
  PalReq:='Mask2';
    {The starting Gas pattern is some geometric objects}
  PatReq:='Pond';
  GenRule(CaRule);
END.
