PROGRAM VoteDna;
{The Vichniac voting rule with the seven extra bits used as memory,}
{as in VoteMem.  The additional twist here is that we increment the}
{color bits by the NineSum each time.  The inland cells quickly}
{converge to the state X which is a fixed point for the transformation}
{NewX = ((OldX + 9)*2)-256)+1.	Replacing NewX and OldX by X and solving,}
{we get X=237.	Change the color for state 237 to 0 (CGA) or 1,1,1 (VGA),}
{and see that the line of thought is correct, as the internal pinkish}
{inland cells disappear.  What remains are thick, seething boundary bands.}
{Loading the palette map "VoteBow" blanks 237 automatically.}

USES Camake;
{$F+}	  { Required for function argument to genrule. }

FUNCTION Carule(Oldstate,NW,N,NE,W,Self,E,SW,S,SE:integer):integer;
VAR
  NineSum,NewSelf,NewState:integer;
BEGIN  {Function}
  NineSum:=NW+N+NE+E+SE+S+SW+W+Self;
  CASE NineSum OF
    0,1,2,3,5: NewSelf:=0;
    4,6,7,8,9: NewSelf:=1;		 {The usual Vote rule}
  END;
  NewState:=OldState+NineSum;		 {To show more info}
  NewState:=(NewState SHL 1) AND $FE;	 {To save past info,}
     {and to clear out the Vote cell.  "AND $FE" keeps CaRule< 256}
  NewState:=NewState OR NewSelf;	 {Load the Vote result}
  CaRule:=NewState
END;  {Function}

BEGIN {Main}
  PalReq:='VoteDna';
  GenRule(CaRule)
END.  {Main}

