PROGRAM XTC;
{This rule implements the XGas (HPPGas) and the TGas (TMGas) rules at the same time,
 producing two interpenetrating gases.	XGas moves along diagonals,
 hence the new name, and TGas moves horizontally and vertically.
 We set up a lattice of position values that looks like this:
				       0 1 0 1 ..
				       2 3 2 3 ..
				       0 1 0 1 ..
				       2 3 2 3 ..
				       : : : :
  This lattice is alternately chunked into
	 A blocks 0 1	and  B blocks 3 2
		  2 3		      1 0
  For TM TGas,the blocks are rotated one notch CCW in phase A & one notch
 CW  in phase B, EXCEPT when a block has form	1 0   or 0 1
						0 1	 1 0
  ,which is the Collision case. In the collision case, block stays same.
  For HPP XGas: IF Collsion THEN NewSelf:=CW ELSE NewSelf:=OPP}

USES Camake;

{$F+}	  { Required for function argument to genrule. }

FUNCTION CaRule(Oldstate,NW,N,NE,W,Self,E,SW,S,SE:integer):integer;
{We use the eight bits of state as follows:
 Bit   #0 is the machine visible bit for update
 Bit   #1 is T gas (vertical/horizontal)
 Bit   #2 is X gas (diagonal)
 Bit   #3 is reserved for a self-erasing startup mask
 Bits  #4 & #5 hold a position number between 0 and 3
 Bit   #6 and #7 control the cycle.
       In cycle 0 we update the  T gas in lattice A. 
       In cycle 1 we update the  T gas in lattice B.
       In cycle 2 we update the  X gas in lattice A.
       In cycle 3 we update the  X gas in lattice B.}
VAR
  Cycle,NewCycle,Position,XGas,TGas,NewSelf,NewState:integer;
  Collision:boolean;
BEGIN
  Cycle:=(OldState SHR 6) AND 3;
  Position:=(OldState SHR 4) AND 3;
  {For all the gas updates we simply calculate NewSelf
   and worry about where to store them below}

  IF Cycle=0 THEN      {TGas A.  Rotate CCW if no collision}
    CASE Position OF
      0: BEGIN
	   Collision:=(Self=SE)AND(E=S);
	   IF NOT(Collision) THEN NewSelf:=E ELSE NewSelf:=Self;
	 END;
      1: BEGIN
	   Collision:=(Self=SW)AND(W=S);
	   IF NOT(Collision) THEN NewSelf:=S ELSE NewSelf:=Self;
	 END;
      2: BEGIN
	   Collision:=(Self=NE)AND(E=N);
	   IF NOT(Collision) THEN NewSelf:=N ELSE NewSelf:=Self;
	 END;
      3: BEGIN
	   Collision:=(Self=NW)AND(W=N);
	   IF NOT(Collision) THEN NewSelf:=W ELSE NewSelf:=Self;
	 END;
    END;
  IF Cycle=1 THEN      {TGas B.  Rotate CW if no collision}
    CASE Position OF
      0: BEGIN
	   Collision:=(Self=NW)AND(W=N);
	   IF NOT(Collision) THEN NewSelf:=N ELSE NewSelf:=Self;
	 END;
      1: BEGIN
	   Collision:=(Self=NE)AND(E=N);
	   IF NOT(Collision) THEN NewSelf:=E ELSE NewSelf:=Self;
	 END;
      2: BEGIN
	   Collision:=(Self=SW)AND(W=S);
	   IF NOT(Collision) THEN NewSelf:=W ELSE NewSelf:=Self;
	 END;
      3: BEGIN
	   Collision:=(Self=SE)AND(E=S);
	   IF NOT(Collision) THEN NewSelf:=S ELSE NewSelf:=Self;
	 END;
    END;
  {For XGas, In both A and B do}
  {IF Collsion THEN NewSelf:=CW ELSE NewSelf:=OPP}
  IF Cycle=2 THEN	{Xgas lattice A}
  {Block has form 0 1
		  2 3}
    CASE Position OF
      0: BEGIN
	   Collision:=(Self=SE)AND(E=S);
	   IF Collision THEN NewSelf:=E ELSE NewSelf:=SE;
	 END;
      1: BEGIN
	   Collision:=(Self=SW)AND(W=S);
	   IF Collision THEN NewSelf:=S ELSE NewSelf:=SW;
	 END;
      2: BEGIN
	   Collision:=(Self=NE)AND(E=N);
	   IF Collision THEN NewSelf:=N ELSE NewSelf:=NE;
	 END;
      3: BEGIN
	   Collision:=(Self=NW)AND(W=N);
	   IF Collision THEN NewSelf:=W ELSE NewSelf:=NW;
	 END;
    END;
  {IF Collison NewSelf:=CW ELSE NewSelf:=OPP}
  IF Cycle=3 THEN			{XGas Lattice B}
  {Block has form 3 2
		  1 0}
    CASE Position OF
      0: BEGIN
	   Collision:=(Self=NW)AND(W=N);
	   IF Collision THEN NewSelf:=W ELSE NewSelf:=NW;
	 END;
      1: BEGIN
	   Collision:=(Self=NE)AND(E=N);
	   IF Collision THEN NewSelf:=N ELSE NewSelf:=NE;
	 END;
      2: BEGIN
	   Collision:=(Self=SW)AND(W=S);
	   IF Collision THEN NewSelf:=S ELSE NewSelf:=SW;
	 END;
      3: BEGIN
	   Collision:=(Self=SE)AND(E=S);
	   IF Collision THEN NewSelf:=E ELSE NewSelf:=SE;
	 END;
    END;
{OK, now we have to store what's what}
TGas:=(OldState SHR 1) AND 1;
XGas:=(OldState SHR 2) AND 1;
NewCycle:=(Cycle+1)MOD 4;
NewState:=(NewCycle SHL 6)OR(Position SHL 4); {This is just the easy stuff}
CASE Cycle OF
  0:  {TGas was updated.  Make TGas visible for next}
      CaRule:=NewState OR (XGas SHL 2) OR (NewSelf SHL 1) OR NewSelf;
  1:  {TGas was updated.  Make XGas visible for next}
      CaRule:=NewState OR (XGas SHL 2) OR (NewSelf SHL 1) OR XGas;
  2:  {X Gas was updated.  Make X visible for next}
      CaRule:=NewState OR (NewSelf SHL 2) OR (TGas SHL 1) OR NewSelf;
  3:  {X Gas was updated.  Make T visible for next}
      CaRule:=NewState OR (NewSelf SHL 2) OR (TGas SHL 1) OR TGas;
END
END;

BEGIN		 {Main program}
    {We set a horizontal pattern of alternate 0s and 1s in bit 4
     and a vertical pattern of alternate 0s and 1s in bit 5.
     This produces a pattern that goes 0 1 0 1 ..
				       2 3 2 3 ..
				       0 1 0 1 ..
				       2 3 2 3 ..
				       : : : :	      }
  texthb:=4;
  texthn:=1;
  textvb:=5;
  textvn:=1;
{  rseedb:=0;
  rseedn:=3;
  rseedp:=10;}
    {The XTC.CAC palette only depends on bits 1 and 2}
  PalReq:='XTC';
    {The starting XTC pattern is an X of X gas, a T of T gas, and
     a C of both gasses}
  PatReq:='XTC';
  GenRule(CaRule);
END.
