/*

			   Dump CelLab population history log file

		Designed and implemented in May of 1990 by John Walker,
		converted from C++ to a civilised tongue by the same older,
		wiser hacker in December of 1995. 
		
				 This program is in the public domain.

*/

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

typedef enum Bool_type {False = 0, True = 1} Boolean;

static Boolean honestEndian;

/*	Forward procedures  */

static void help(void);

/*	Byte order conversion routines (needed on non-80x86 architectures).
	Dynamic determination of byte order is ugly and inefficient, but
	eliminates any assumptions about preprocessor symbols indicating
	architecture which may differ from compiler to compiler and system
	to system.  */

static void cvshort(unsigned short *sh)
{
	if (honestEndian) {
		short shc;
		unsigned char *op = (unsigned char *) sh,
					  *ip = (unsigned char *) &shc;
		
		shc = *sh;
		op[1] = ip[0];
		op[0] = ip[1];
	}
}

static void cvlong(long *lg)
{
	if (honestEndian) {
		long lgc;
		unsigned char *op = (unsigned char *) lg,
					  *ip = (unsigned char *) &lgc;
		
		lgc = *lg;
		op[0] = ip[3];
		op[1] = ip[2];
		op[2] = ip[1];
		op[3] = ip[0];
	}
}

/*	Main program  */

int main(int argc, char *argv[])
{
	int i;
	char *cp, opt;
	Boolean fp = False;
	char ofilename[256];
	char ibuf[512];
	FILE *fd;
	static long testLong = 0x12345678;
	static short testShort = 0x1234;
	static unsigned char byteLongLittle[4] =  { 0x78, 0x56, 0x34, 0x12 },
						 byteLongBig[4] =	  { 0x12, 0x34, 0x56, 0x78 },
						 byteShortLittle[2] = { 0x34, 0x12 },
						 byteShortBig[2] =	  { 0x12, 0x34 };
						  
	for (i = 1; i < argc; i++) {
	   cp = argv[i];
	   if (*cp == '-') {
		  opt = *(++cp);
		  if (islower(opt))
			 opt = toupper(opt);
		  switch (opt) {
	
	         case '?':
	         case 'U':
				help();
				exit(0);
		  }
	   } else {
		  if (fp) {
	         fprintf(stderr,  "Duplicate file name specification.\n");
			 return 1;
		  }
		  strcpy(ofilename, cp);
		  fp = True;
	   }
	}
	
	if (memcmp((char *) &testLong, (char *) byteLongBig, 4) == 0 &&
		memcmp((char *) &testShort, (char *) byteShortBig, 2) == 0) {
		honestEndian = True;
	} else if (memcmp((char *) &testLong, (char *) byteLongLittle, 4) == 0 &&
			   memcmp((char *) &testShort, (char *) byteShortLittle, 2) == 0) {
		honestEndian = False;
	} else {
	
		/* Call me paranoid, or just a 'noid for short, but I've not only
		   spent more than 10 years programming 36 bit machines, I've
		   written *Windows* programs! */
		   
		unsigned char *dp = (unsigned char *) &testShort;
		
		fprintf(stderr, "Machine has no known byte order.\n");
		fprintf(stderr, "  Short 0x1234     is: %02X %02X\n", dp[0], dp[1]);
		dp = (unsigned char *) &testLong; 
		fprintf(stderr, "   Long 0x12345678 is: %02X %02X %02X %02X\n",
			dp[0], dp[1], dp[2], dp[3]);
		return 1; 
	} 
	
	if (!fp) {
	   fprintf(stderr,  "No history file name specified.\n");
	   help();
	   return 1;
	}
	
	if (strchr(ofilename, '.') == NULL)
	   strcat(ofilename, ".jch");
	
	if ((fd = fopen(ofilename, "rb")) == NULL) {
	   fprintf(stderr,  "Cannot open input file %s\n", ofilename);
	   return 1;
	}
	
	if (fread(ibuf, 24, 1, fd) != 1) {
	   fprintf(stderr,  "Header missing from history file.\n");
	   return 1;
	}
	
	if (memcmp(ibuf, "CelLab population log\r\n\032", 24) != 0) {
	   fprintf(stderr,  "Invalid header in history file.\n");
	   return 1;
	}
	
	while (fread(ibuf, 16, 1, fd) != 0) {
	   int i, j, l;
	   long genct;
	   unsigned short *hp;
	   unsigned short totcells;
	
	   fread((char *) &genct, sizeof genct, 1, fd);
	   cvlong(&genct);
	   printf("Rule: %s  Generation: %ld\n", ibuf, genct);
	   if (fread(ibuf, 512, 1, fd) != 1) {
	      fprintf(stderr,  "History file truncated.\n");
		  return 1;
	   }
	   hp = (unsigned short *) ibuf;
	   for (l = 255; l > 1; l--) {
		  if (hp[l] != 0)
			 break;
	   }
	   l = (l & (~7)) + 8;
	   totcells = 0;
	   for (i = 0; i < l; i += 8) {
	      printf("%3d: ", i);
		  for (j = 0; j < 8; j++) {
			 cvshort(&hp[i + j]);
	         printf(" %8u", hp[i + j]);
			 totcells += hp[i + j];
		  }
	      printf("\n");
	   }
	   if (totcells != 64000u) {
	      printf("Error: total cell count was %u; 64000 expected.\n\n",
			 totcells);
	   }
	}
	return 0;
}

/*	HELP  --  Print information on how to call	*/

static void help(void)
{
	fprintf(stderr,  "\nPHDUMP  --  Cellular automaton population history dump.");
	fprintf(stderr,  "\n            Call with PHDUMP [options] histfile");
	fprintf(stderr,  "\n");
	fprintf(stderr,  "\n   Options:");
	fprintf(stderr,  "\n        -?     Print this message");
	fprintf(stderr,  "\n        -U     Print this message");
	fprintf(stderr,  "\n");
}
