
    #   Subroutines for processing AW-SRAD CSV files

    require 'csv.pl';

    #   AW-SRAD CSV files are always written using
    #   "East coast time"--the time zone of Aware
    #   Electronics in Delaware in the United States.
    #   The following provides the offset to convert
    #   these parochial times to standard Unix UTC
    #   time() values.

    $GMToffset = -7 * 60 * 60;

    #   Read next record from standard input

    sub readrad {
        local $l, $f, $counts, $time;

        if (!($l = <>)) {
            return (-1, -1);
        }

        chop($l);
        @f = &csv($l);
#       print(join(',', @f) . "\n");
        $counts = $f[0];
        $time = $f[1] + $GMToffset;
        return ($counts, $time);
    }

1;
