
    #	Note:  This program *does not* process a standard Apache server
    #	log of any kind.  It reads a special "forensic log" which includes
    #	the Cache-Control and Pragma header lines from the HTTP request.
    #	You can create such a log by adding the following to your
    #	Apache server configuration file:
    #
    #	LogFormat "%h %l %u %t \"%r\" %>s %b \"%{Referer}i\" \"%{User-Agent}i\" \"%{Cache-Control}i\" \"%{Pragma}i\"" forensic
    #	CustomLog /files/server/logs/http/forensic_log forensic
    #
    #	Of course you'll want to change the log file path in the CustomLog
    #	declaration to something appropriate for your server.

    use Time::Local;
    
    #	Target page status item
    $target_page = 'GET / HTTP/1.1';

    $num_lines = 0;
    $ignored_lines = 0;
    $ltimebin = 0;
    
    %mnames = split(/,/, "Jan,1,Feb,2,Mar,3,Apr,4,May,5,Jun,6,Jul,7,Aug,8,Sep,9,Oct,10,Nov,11,Dec,12");
    
    while ($l = <>) {
    	$l =~ s/\s+$//;

#print("$l\n");	
	#   Parse request record
	$l =~ m/^(\d+\.\d+\.\d+\.\d+)\s+(\S+)\s+(\S+)\s+\[(.*)\]\s+"(.*)"\s+(\d+)\s+([\-\d]+)\s"((?:[^"]|"")*)"\s"((?:[^"]|"")*)"\s"((?:[^"]|"")*)"\s"((?:[^"]|"")*)"/;
	$ip = $1;
	$ident = $2;
	$userid = $3;
	$time_date = $4;
	$request = $5;
	$status = $6;
	$length = $7;
	$referer = $8;
	$agent = $9;
	$cachecont = $10;
	$pragma = $11;
#print("$time_date\n");	
	
	#   Parse date and time field
	$time_date =~ m-(\d+)/(\w+)/(\d+):(\d+):(\d+):(\d+)\s([\+\-]\d+)$-;
	$mday = $1;
	$mon = $2;
	$year = $3;
	$hour = $4;
	$minute = $5;
	$second = $6;
	$timezone = $7;
	$mindex = $mnames{$mon};
	$iso_date = sprintf("%04d-%02d-%02d %02d:%02d:%02d", $year, $mindex, $mday,
	    	    	    	$hour, $minute, $second);
	eval {
	    $utime = timelocal($second, $minute, $hour, $mday, $mindex - 1, $year);
	};
	
#print("$mday,$iso_date,$year,$hour,$minute,$second,$timezone\n");

#print("\n$l\n");	
#print ("$ip,$ident,$userid,$time_date,$request,$status,$length\n    ($referer)\n    ($agent)\n    ($cachecont)\n    ($pragma)\n");

    	if (($request eq $target_page) && 
	    ($referer eq '-') && ($agent eq '-') &&
    	    (($cachecont =~ m/no\-cache/) || ($pragma =~ m/no\-cache/))) {
    	    $num_lines++;

if (!defined($hits{$ip})) {
 $fhit{$ip} = sprintf("* $ip,$ident,$userid,$time_date,$request,$status,$length\n*     ($referer)\n*     ($agent)\n*     ($cachecont)\n*     ($pragma)\n");
}
	    
	    $hits{$ip}++;
	    if (!defined($first{$ip})) {
	    	$first{$ip} = $iso_date;
		$ufirst{$ip} = $utime;
	    }
	    $last{$ip} = $iso_date;
	    $ulast{$ip} = $utime;
	    
	    $timebin = int($utime / 3600) * 3600;
	    $timehist{$timebin}++;
	    if ($ltimebin != $timebin) {
	    	if ($ltimebin != 0) {
	    	    foreach $uh (keys %uhosts) {
		    	if ($uhosts{$uh} >= 10) {
			    $unique_hosts{$ltimebin}++;
			    if (!defined($ohosts{$uh})) {
				$new_hosts{$ltimebin}++;
				$ohosts{$uh} = 1;
			    }
			}
		    }
		}
	    	undef(%uhosts);
		$ltimebin = $timebin;
	    }
	    $uhosts{$ip}++;
	} else {
	    $ignored_lines++;
if (defined($hits{$ip})) {
print($fhit{$ip});
print("$ip,$ident,$userid,$time_date,$request,$status,$length\n    ($referer)\n    ($agent)\n    ($cachecont)\n    ($pragma)\n");
$follow_up++;
}
	}
    }
    
    print("Total records processed: $num_lines\n");
    print("Total records ignored:   $ignored_lines\n");
    print("Hits subsequent to apparent attack: $follow_up\n");
    
    #	Update unique hosts for last time bin
    foreach $uh (keys %uhosts) {
	if ($uhosts{$uh} >= 10) {
	    $unique_hosts{$timebin}++;
	    if (!defined($ohosts{$uh})) {
		$new_hosts{$timebin}++;
		$ohosts{$uh} = 1;
	    }
	}
    }
