
    #	Monitor a live, appended HTTP forensic log and maintain
    #	a list of currently attacking hosts.

    #	This program reads an HTTP log in "forensic format" as defined by:
    #
    #	LogFormat "%h %l %u %t \"%r\" %>s %b \"%{Referer}i\" \"%{User-Agent}i\" \"%{Cache-Control}i\" \"%{Pragma}i\" \"%{X-Forwarded-For}i\"" forensic
    #	CustomLog /files/server/logs/http/forensic_log forensic

$prime_time = 1;

    use Time::Local;
    
    if ($#ARGV != 0) {
    	print(STDERR "usage: perl attack_denial.pl forensic_log_file\n");
	exit(0);
    }
    
    open(FL, "<$ARGV[0]") || die "Unable to open forensic log file $ARGV[0]";
    seek(FL,  0, 2);	    	# Seek to end of log file
        
    #	Frequency of update dumps in seconds
    $updtime = 5 * 60;
    
    #	Time out hosts after this many seconds without a hit
    $timeout = 120 * 60;
    
    #	Minimum hits from IP address to deem an attacker
    $minhits = 2;
    
    #	Where to read IP Filter configuration file template
    $templatefile = 'ipf_conf_template.txt';
    
    #	Sentinel marking where rules are interpolated in ipf.conf file
    $templatesentinel = '#### INSERT ATTACK_DENIAL RULES HERE ####';
    
    #	Where to write IP Filter configuration file
    $filtfile = 'ipf.conf';
    
    #	Command to load new rule set into IP Filter
    $reload_IP_Filter = '/etc/init.d/ipfboot reipf';
    
    #	IP Filter packet disposition log
    $read_IP_Filter_log = '/files/server/logs/http/ipfilter_log';
    
    #	Adjust file paths if we're actually running in production
    if ($prime_time) {
    	$templatefile = '/etc/opt/ipf/ipf_conf_template.txt';
	$filtfile = '/etc/opt/ipf/ipf.conf';
    }

    $lastupd = 0;   	    	# Time of last update dump
    
    %mnames = split(/,/, "Jan,1,Feb,2,Mar,3,Apr,4,May,5,Jun,6,Jul,7,Aug,8,Sep,9,Oct,10,Nov,11,Dec,12");

    if (defined($read_IP_Filter_log)) {
    	open(FLOG, "<$read_IP_Filter_log") || die "Cannot start IP Filter log ($read_IP_Filter_log)";
    	seek(FLOG,  0, 2);  	    	    # Seek to end of IP Filter log file
    }

    while (1) {    
	while ($l = <FL>) {
    	    $l =~ s/\s+$//;

	    #   Parse request record
	    if ($l !~ m/^(\d+\.\d+\.\d+\.\d+)\s+(\S+)\s+(\S+)\s+\[(.*)\]\s+"(.*)"\s+(\d+)\s+([\-\d]+)\s"((?:[^"]|"")*)"\s"((?:[^"]|"")*)"\s"((?:[^"]|"")*)"\s"((?:[^"]|"")*)"\s"((?:[^"]|"")*)"/) {
#print("Ditch $l\n");
		next;
	    }
	    	    
	    #	Quick reject non-hit log items
	    if ($6 != 573) {
if (defined($hits{$1})) {
    print(STDERR "++OOPS: $l\n");
    delete($ulast{$k});
    delete($ufirst{$k});
    delete($hits{$k});
print(STDERR "--Purged by non-homepage hit $k\n");
    
}
	    	next;
	    }
	    
	    #	Quick reject hits relayed by proxy servers
	    if ($12 ne '-') {
	    	next;
	    }
	    
	    $ip = $1;
	    $ident = $2;
	    $userid = $3;
	    $time_date = $4;
	    $request = $5;
	    $status = $6;
	    $length = $7;
	    $referer = $8;
	    $agent = $9;
	    $cachecont = $10;
	    $pragma = $11;
	    $proxy = $12;
	    if ($length eq '-') {
		$length = 0;
	    }
	    
	    #   Parse date and time field
	    $time_date =~ m-(\d+)/(\w+)/(\d+):(\d+):(\d+):(\d+)\s([\+\-]\d+)$-;
	    $mday = $1;
	    $mon = $2;
	    $year = $3;
	    $hour = $4;
	    $minute = $5;
	    $second = $6;
	    $timezone = $7;
	    $mindex = $mnames{$mon};
	    $iso_date = sprintf("%04d-%02d-%02d %02d:%02d:%02d", $year, $mindex, $mday,
	    	    	    	    $hour, $minute, $second);
	    $utime = timelocal($second, $minute, $hour, $mday, $mindex - 1, $year);

#print("$mday,$iso_date,$year,$hour,$minute,$second,$timezone\n");

#print ("$ip,$ident,$userid,$time_date,$request,$status,$length,$cachecont,$pragma,$proxy\n");

 	    $hits{$ip}++;
print("--($hits{$ip}) $l\n");
	    if (!defined($ufirst{$ip})) {
		$ufirst{$ip} = $utime;
	    }
	    $ulast{$ip} = $utime;
	}
	
	#   If $read_IP_Filter_log is defined, read new records
	#   from the IP Filter log monitor and update last
	#   access time for each IP address from which we've
	#   blocked a packet.
	
	if (defined($read_IP_Filter_log)) {
	    while ($l = <FLOG>) {
# print("FLOG: $l");
    	    	if ($l =~ m-^(\d+)/(\d+)/(\d+)\s+(\d+):(\d+):(\d+)\.(\d+)\s+\w+\s+\@\d+:\d+\s+(\w)\s+(\d+\.\d+\.\d+\.\d+),-) {
		    $utime = timelocal($6, $5, $4, $1, $2 - 1, $3);
		    $bp = $8;
		    $ip = $9;
# $zza = join("-", localtime($utime));
# print("Filter: $zza $bp $ip\n");
    	    	    if (($bp eq 'b') && (defined($ufirst{$ip}))) {
		    	$ulast{$ip} = $utime;
			$hits{$ip}++;
print("-+($hits{$ip}) $l");
		    }
    	    	}
	    }
	}
	
	if ((time() - $lastupd) >= $updtime) {
	    &update;
	}
print(STDERR "--Sleeping\n");
    	sleep(10);
    }
    
    sub update {
    	$now = time();
	
	open(TE, "<$templatefile") || die "Unable to open template file $templatefile";
    	open(OF, ">$filtfile");
	
	while (<TE>) {
	    if ($_ =~ m/^$templatesentinel/) {
	    	last;
	    }
	    print(OF);
	}
	
	my @toh;
	my $nblock = 0;
    	foreach $k (sort keys %ulast) {
	    if (($now - $ulast{$k}) >= $timeout) {
	    	print(STDERR "--Timeout: $k\n");
		push(@toh, $k);
	    } else {
	    	if ($hits{$k} >= $minhits) {
	    	    $mina = int(($now - $ufirst{$k}) / 60);
	    	    print(OF "block in log quick from $k to any  # $mina min. $hits{$k} hits\n");
		    $nblock++;
		}
	    }
	}
	foreach $k (@toh) {
    	    delete($ulast{$k});
	    delete($ufirst{$k});
	    delete($hits{$k});
print(STDERR "--Timeout purged $k\n");
	}
	
	while (<TE>) {
	    print(OF);
	}

	close(OF);
	printf(STDERR "--Blocked $nblock hosts.\n");
	$lastupd = time();
	
	if ($prime_time) {
		system("$reload_IP_Filter\n");
	}
    }
 
