
    #	Cross-correlate IP addresses from different
    #	sources.  A list of IP addresses is loaded
    #	from the file target_ips.txt, then records
    #	from the ipstat.txt produced by ddos_stat.pl
    #	are scanned and those which match one of the
    #	target IP addresses are printed.
    
    #	Uncommmenting the lines tagged # ACCESS and
    #	commenting the lines which they immediately
    #	precede configures the program to scan an
    #	HTTP access_log and print accesses from IPs
    #	in the target list.

    #	Load list of IPs to be searched for into hash
    
    open(FI, "<target_ips.txt");
    
    $n = 0;
    while ($l = <FI>) {
    	$l =~ s/\s//g;
	if ($l =~ m/(\d+\.\d+\.\d+\.\d+)/) {
	    $target{$1} = 1;
	    $n++;
	} else {
	    print(STDERR "Couldn't parse IP address: $l\n");
	}
    }
    close(FI);
    
    print(STDERR "Loaded $n IP address targets.\n");
    
    open(FI, "<ipstat.txt");
#   open(FI, "</files/server/logs/http/access_log");	# ACCESS
    while ($l = <FI>) {
	if ($l =~ m/\s*\d+\s+(\d+\.\d+\.\d+\.\d+)/) {
#	if ($l =~ m/(\d+\.\d+\.\d+\.\d+)\s/) {	    	# ACCESS
	    $ip = $1;
#	    print("<$ip>\n");
    	    if (defined $target{$ip}) {
	    	$target{$ip}++;
	    	print("$l");
	    }
	}
    }
    close(FI);
    
    #	The following only makes sense for an ACCESS run

    $n = 0;
    $t = 0;
    for $k (keys %target) {
    	if ($target{$k} > 1) {
	    $n++;
	    $t += $target{$k} - 1;
	}
    }
    
    print("\n$n hosts with visits in log\n$t total hits from these hosts\n");
