
    #	Merge domain names discovered subsequently (see
    #	retro_extract_ips.pl) into an attack report.  Lines
    #	which don't conform to to IP attack incidents are
    #	output unmodified, as are those for which resolution
    #	has already been performed.  The attack report is read
    #	from standard input, and the updated attack report is
    #	written to standard output.
    
    #	Load host database
    
    if (open(HD, "<hostdb.txt")) {
    	while ($l = <HD>) {
	    chomp($l);
	    $l =~ m/^(\S+)\s+(\S+)/;
	    $hostdb{$2} = $1;
	    if ($1 eq $2) {
	    	$hostdb{$2} = '?';  	# IP address tried, but did not resolve
	    }
	}
	close(HD);
    }
    
        while ($l = <>) {
    	chomp($l);
	
	if ($l =~ m/(^\s+\d+\s+)([\d\.]+)(\s+\S+\s\S+\s+\S+\s\S+\s+\d+\s+\d+\s+\d+\s+)(\S*)/) {
	    $ip = $2;
	    $dname = $4;
	    if (($dname eq '') && (defined($hostdb{$ip}))) {
#print("*** $ip ($dname) => ($hostdb{$ip})\n");
    	    	print("$1$2$3$hostdb{$ip}\n");
    	    } else {
	    	print("$l\n");
	    }    
	} else {
	    print("$l\n");
	}
    }
