
    #	Parse "snoop" output and extract IP addresses
    #	of hosts who requests are being forwarded by
    #	proxy servers.
    
    #	You run the snoop which is input to this
    #	program with:
    #
    #	    snoop -x 0 123.45.67.89 >snoop_output.txt
    
    #	Output of this program can be post-processed
    #	with:
    #
    #	    sort | uniq
    #
    #	to prepare a list of unique IP addresses and the
    #	proxy server which is forwarding their hits.

    while ($l = <>) {
    	chomp($l);
	
	if ($l =~ m/\->.*HTTP\sGET/) {
#print("$l\n");
    	    $l =~ m/(\S+)/;
	    $proxy = $1;
#print("Proxy: ($proxy)\n");
    	    $s = <>;	    	# Blank line
	    
	    $p = '';
	    while ($l = <>) {
	    	chomp($l);
		if (length($l) == 0) {
		    last;
		}
#		print("$l\n");
		$p .= substr($l, 50, 16);
    	    }
#    	    print(">$p<\n");
    	    $p =~ m/X\-Forwarded\-For:\s(\d+\.\d+\.\d+\.\d+)\D/;
	    $ip = $1;
	    printf("%-18s    %s\n", $ip, $proxy);
	}
    }
