/*

	Create in-memory image, flattened to 256 colours if required

*/

#include "screensv.h"

char *loadError = NULL;					// Error message for image load

//  LOADIMAGE  --  Load image into memory

int loadImage(FILE *input_file, HGLOBAL *LimageBitmap,
			  int *LsizeX, int *LsizeY)
{
	int s;
	HGLOBAL imageBitmap = NULL;			// In-memory bitmap
	LPBITMAPINFOHEADER bh;

	synth_setup();
	s = synthesise_image(&imageBitmap, LsizeX, LsizeY);
	bh = (LPBITMAPINFOHEADER) imageBitmap;
	if (s) {

		/*	If the display is 256 colour or the user has explicitly
			requested a palette-mapped image, transform full colour
			bitmaps into 256 colour replacements.  */

		if (usePalette && (bh->biBitCount > 8)) {
			HGLOBAL newBitmap;

			Ticker("Quant");
			ticker();
			newBitmap = quantifyBMP(imageBitmap);
			free(imageBitmap);
			if (newBitmap == NULL) {
				loadError = "Cannot create colour palette for true colour BMP file.";
				return FALSE;
			}
			imageBitmap = newBitmap;
			bh = (LPBITMAPINFOHEADER) imageBitmap;
		}
	}
	*LimageBitmap = imageBitmap;
	return imageBitmap != NULL;
}