/*

			Display Bitmap Image on Screen

*/

#include "screensv.h"

int ImageWid = -1;				  			// Width of master image
int ImageHgt = -1;							// Height of master image
static HPALETTE imagePal = NULL;			// Custom colour palette
int screenX, screenY;						// Screen width and height

static struct {
	WORD	palVersion;
	WORD	palNumEntries;
	PALETTEENTRY palPalEntry[256];
} logpal;

static HGLOBAL imageBitmap = NULL;			// Copy of bitmap resource
static currentImageIndex = 0;				// Index of image now on screen
static int DisplayWid, DisplayHgt;			// Image dimensions as displayed
#ifdef TICKER_DEBUG
char *tickerWhat = "Init ";
int tickerTicks = 0;
#endif

//	PALMAPSTART  --  Create a replacement palette bitmap header.

static LPBITMAPINFOHEADER bm = NULL;

static LPBITMAPINFOHEADER palMapStart(LPBITMAPINFOHEADER bh, int *bmode)
{
	WORD i, ncol, offbits;
	unsigned short *palidx;
    
    assert(bm == NULL);
	ncol = (WORD) (bh->biClrUsed == 0 ? (1L << bh->biBitCount) : bh->biClrUsed);
	offbits = (WORD) (bh->biSize + ncol * sizeof(RGBQUAD));
	bm = malloc(offbits);
	if (bm != NULL) {
		*bmode = DIB_PAL_COLORS;
		memcpy(bm, bh, offbits);
		bm->biClrUsed = bm->biClrImportant = ncol;
		palidx = (unsigned short *) ((LPBITMAPINFO) bm)->bmiColors; 
		for (i = 0; i < ncol; i++) {
			*palidx++ = (unsigned short) i;
		}
		return bm;
	}
	*bmode = DIB_RGB_COLORS;
	return bh;	
}

//	PALMAPEND  --  Release palette map buffer, if any.

static void palMapEnd(void)
{
	if (bm != NULL) {
		free(bm);
		bm = NULL;
	}
} 

//  NEEDIMAGEBITMAP  --  Make sure image bitmap and palette are loaded.

static void needImageBitmap(void)
{
	int i;
	LPBITMAPINFOHEADER bh;

	ImageWid = ImageHgt = -1;
	imageBitmap = NULL;
	imagePal = NULL;

	loadError = NULL;
	i = loadImage(NULL, &imageBitmap, &ImageWid, &ImageHgt);
	if ((!i) || (imageBitmap == NULL)) {
		release_image();
		return;
	}

    bh = (LPBITMAPINFOHEADER) imageBitmap;
    if (bh->biBitCount <= 8) {
		int ncol = bh->biClrUsed == 0 ? (1L << bh->biBitCount) : bh->biClrUsed;
	
		/* Extract the colour palette from the DIB file and
		   construct a memory logical palette embodying those colours.  Then
		   register the palette with the system to provide those colours on
		   the display. */
	
		logpal.palVersion = 0x300;
		logpal.palNumEntries = ncol;
		for (i = 0; i < ncol; i++) {
			RGBQUAD q = *((LPRGBQUAD) &((LPBITMAPINFO) bh)->bmiColors[i]);

			logpal.palPalEntry[i].peRed = q.rgbRed;
			logpal.palPalEntry[i].peGreen = q.rgbGreen;
			logpal.palPalEntry[i].peBlue = q.rgbBlue;
			logpal.palPalEntry[i].peFlags = PC_NOCOLLAPSE;
		}
	
		imagePal = CreatePalette((LPLOGPALETTE) &logpal);
	}
}

//  PAINTDIB  --  Paint the image DIB onto the device surface.

static int zstatus, lposX = -1, lposY = -1;

static void paintDIB(HWND hWnd, HDC hDC)
{
	LPBITMAPINFOHEADER obmap, bp;
	WORD ncol, offbits;
	int bmode = DIB_RGB_COLORS;
	unsigned char *opixel;
	HPALETTE opal;
	RECT rc;
	int posx, posy;
	int tdo = (showDateTime && !fChildPreview) ? (tmx.tmHeight + 1) : 0;

	DisplayWid = ImageWid;
	DisplayHgt = ImageHgt;
	GetClientRect(hWnd, &rc);

	posx = 0;
	posy = 0;
	lposX = posx;
	lposY = posy;
	obmap = (LPBITMAPINFOHEADER) imageBitmap;
	ncol = (WORD) ((imagePal != NULL) ? (obmap->biClrUsed == 0 ? (1L << obmap->biBitCount)
															   : obmap->biClrUsed)
									  : 0);
	bp = obmap;
	if (imagePal != NULL) {
		bp = palMapStart(obmap, &bmode);
	}
	offbits = (WORD) (obmap->biSize + ncol * sizeof(RGBQUAD));
	opixel = ((unsigned char *) (obmap)) + offbits;
	if (imagePal != NULL) {
		opal = SelectPalette(hDC, imagePal, FALSE);
		RealizePalette(hDC);
	}

	FillRect(hDC, &rc, (HBRUSH) GetStockObject(BLACK_BRUSH));

	zstatus = SetDIBitsToDevice(hDC, posx, posy, ImageWid, ImageHgt,
		0, 0, 0, ImageHgt,
		opixel, (LPBITMAPINFO) bp, bmode);

	/*	Idiot SetDIBitsToDevice can die if there isn't enough memory
		to do the whole screen at once.  Spoon feed the drooling
		Microsoft morons a line at a time when this happens.  */

	if (zstatus < ImageHgt) {
		int i;

		for (i = 0; i < ImageHgt; i++) {
			zstatus = SetDIBitsToDevice(hDC, posx, posy + i, ImageWid, 1,
						0, i, i, 1,
						opixel, (LPBITMAPINFO) bp, bmode);
			if (zstatus == 0) {
				break;
			}
		}
		zstatus = i;
	}

	if (zstatus != ImageHgt) {
		loadError = "Insufficient free memory to paint bitmap on screen";
	}

	if (imagePal != NULL) {
		palMapEnd();
		SelectPalette(hDC, opal, FALSE);
	}
}

//	PAINTDATE  --  Paint date and time title above image, if requested

static void paintDate(HDC hDC, struct tm lt)
{
	if (showDateTime && !fChildPreview && (lposX >= 0)) {
		RECT cr;

		cr.left = lposX;
		cr.right = lposX + lastPlanetSize;
		cr.top = 0;
		cr.bottom = (tmx.tmHeight + 1) * 2;
		ssavetime(hDC, lt, cr, skycolour);	// Update time
	}
}

//	TICKER  --  Periodically update seconds counter while calculating sky

static WORD tickerLast = -1;				// Last ticker update time

void ticker(void)
{
	SYSTEMTIME s;
	HDC hTickerDC;

#ifdef TICKER_DEBUG
	tickerTicks++;
#endif
	GetSystemTime(&s);
	if (s.wSecond != tickerLast && !fChildPreview) {
		struct tm lt;
		
		tickerLast = s.wSecond;
		set_tm_time(&lt, TRUE);
		hTickerDC = GetDC(hMainWindow);
		paintDate(hTickerDC, lt);
		ReleaseDC(hMainWindow, hTickerDC);
    }
}

/*	BAILOUT  --  See if we should bail out of calculation early.
				 Note that we don't actually process a pending
				 keyboard or mouse event, simply notify the caller
				 that one is queued.  This allows the screen saver
				 main program to actually receive the event and
				 perform its shut down. */

BOOL bailedOut = FALSE;

BOOL bailout(void)
{
	MSG msg;
	
	if (bailedOut || (!fChildPreview && (
		PeekMessage(&msg, hWndMain, WM_KEYFIRST, WM_KEYLAST, PM_NOREMOVE | PM_NOYIELD) ||
		PeekMessage(&msg, hWndMain, WM_LBUTTONDOWN, WM_LBUTTONDOWN, PM_NOREMOVE | PM_NOYIELD) ||
		PeekMessage(&msg, hWndMain, WM_MBUTTONDOWN, WM_MBUTTONDOWN, PM_NOREMOVE | PM_NOYIELD) ||
		(!right_click_to_copy && PeekMessage(&msg, hWndMain, WM_RBUTTONDOWN, WM_RBUTTONDOWN, PM_NOREMOVE | PM_NOYIELD)) ||
		PeekMessage(&msg, hWndMain, WM_MOUSEMOVE, WM_MOUSEMOVE, PM_NOREMOVE | PM_NOYIELD)
	   ))) {
#ifdef Mdiag
		char s[120];
		
		if (!bailedOut) {
			wsprintf(s, "Bailed on %X, hWnd = %x (oWnd = %x) wParam = %X, lParam = %lX\r\n", msg.message, msg.hwnd, hMainWindow, msg.wParam, msg.lParam);
			OutputDebugString(s);
		} else {
			OutputDebugString("Redundant bailout.\r\n");	
		}
#endif	
		return bailedOut = TRUE;
	}
	return FALSE; 
}

//  UPDVIEWFROM  --  Update image on screen

void updviewfrom(HWND hWnd, BOOL repositioned)
{
	HDC hDC;
    struct tm lt;
	static int changeMode = -1;
	RECT rc;
	BOOL dibbled = FALSE;

	jyear(faketime, &lt.tm_year, &lt.tm_mon, &lt.tm_mday);
	lt.tm_year -= 1900;
	lt.tm_mon--;
	jhms(faketime, &lt.tm_hour, &lt.tm_min, &lt.tm_sec);
	lt.tm_wday = jwday(faketime);

	hDC = GetDC(hWnd);

	//	Paint the date and time above the image

	if (showDateTime && !fChildPreview && (lposX >= 0) && !repositioned) {
		paintDate(hDC, lt);
	}

	if (!repositioned) {
		return;
	}

	//	Okay, it's time for a new image.  Load and display it.

	GetClientRect(hWnd, &rc);
	screenX = rc.right - rc.left;
	screenY = rc.bottom - rc.top;
	bailedOut = FALSE;

	if (imageBitmap == NULL) {
		Ticker("First");
		lastPlanetSize = (min(screenX, screenY) * 3) / 4;
		lposX = (screenX - lastPlanetSize) / 2;
		lposY = 0;
		needImageBitmap();
		lposX = -1;
	}
	if ((loadError == NULL) && (imageBitmap != NULL)) {
		paintDIB(hWnd, hDC);
		dibbled = TRUE;
	}

	if ((loadError != NULL) || (imageBitmap == NULL)) {
		RECT cr;
#define LOAD_ERROR_DIAG
#define LOAD_ERROR_DIAG_SUPPRESS_BAILOUT
#ifdef LOAD_ERROR_DIAG
		char s[256];
		int ryp;
#endif

		if (imageBitmap != NULL) {
			release_image();
		}
		GetClientRect(hWnd, &cr);
		FillRect(hDC, &cr, (HBRUSH) GetStockObject(BLACK_BRUSH));
#ifdef LOAD_ERROR_DIAG
#ifdef LOAD_ERROR_DIAG_SUPPRESS_BAILOUT
		if (!bailedOut)
#endif
		{
			strcpy(s, "Cannot generate image.");
			SetBkMode(hDC, OPAQUE);
			SetTextColor(hDC, RGB(255, 0, 0));
			SetBkColor(hDC, RGB(0, 0, 0));
			SetTextAlign(hDC, TA_CENTER | TA_BASELINE | TA_NOUPDATECP);
			//	Set error text at random position vertically to avoid burn-in
			ryp = (cr.bottom / 8) +
				  ((random() & RAND_MAX) * ((cr.bottom * 6) / 8)) / RAND_MAX;
			TextOut(hDC, cr.right / 2, ryp, s, strlen(s));
			ryp += tmx.tmHeight;
			sprintf(s, "%s.", (loadError == NULL) ? "Unknown error" : loadError);
			TextOut(hDC, cr.right / 2, ryp, s, strlen(s));
#endif
		}
		lposX = -1;
	}

	release_image();
	if (randomPosition && dibbled) {
		lposX = lastPlanetX;
		lposY = 0;
	} else {
		lposX = (screenX - lastPlanetSize) / 2;
		lposY = 0;
	}
	if (dibbled) {
		tickerLast = -1;				// Force ticker to display the time
		ticker();
	}

	//	Generate next image while this one is being displayed.
	bailedOut = FALSE;
#ifdef TICKER_DEBUG
	tickerTicks = 0;
#endif
	Ticker("Next");
	needImageBitmap();
	Ticker("Idle");
	ReleaseDC(hWnd, hDC);
}

//	RELEASE_IMAGE  --  Release storage associated with the image

void release_image(void)
{
	if (imageBitmap != NULL) {
		free(imageBitmap);
		imageBitmap = NULL;
	}
	if (imagePal != NULL) {
		DeleteObject(imagePal);
		imagePal = NULL;
	}
}
