/*

				Definitions

*/

#define ScreenSaver

#ifndef RC_INVOKED
#include <crtdbg.h>
#define _CRTDBG_MAP_ALLOC
#endif
#include <windows.h>
#include <winbase.h>
#include <scrnsave.h>
#include <string.h>
#include <time.h>
#ifndef RC_INVOKED
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <math.h>
#include <search.h>
#include <sys/types.h>
#include <sys/timeb.h>
#include "jpeglib.h"
#endif

typedef RGBQUAD *LPRGBQUAD;

#include "resource.h"

//      String codes in resource file

#define IDS_DAY_NAMES           16          	// Day name base

#define IDS_APPNAME				103				// Application name/title

#define IDS_FORMATS            200          	// Format base
#define Format(n)   rstring(IDS_FORMATS + (n))

#define V       (void)

#define EOS     '\0'

/*  Handy mathematical functions  */

#ifdef abs
#undef abs
#endif

//#define sgn(x) (((x) < 0) ? -1 : ((x) > 0 ? 1 : 0))       /* Extract sign */
#define abs(x) ((x) < 0 ? (-(x)) : (x))                   /* Absolute val */
//#define fixangle(a) ((a) - 360.0 * (floor((a) / 360.0)))  /* Fix angle    */
//#define fixangr(a)  ((a) - (PI*2) * (floor((a) / (PI*2))))/* Fix angle in radians*/
//#define dtr(x) ((x) * (PI / 180.0))                       /* Degree->Radian */
//#define rtd(x) ((x) / (PI / 180.0))                       /* Radian->Degree */
/* #define min(x, y) ((x) < (y) ? (x) : (y))				  /* Minimum */
/* #define max(x, y) ((x) > (y) ? (x) : (y))				  /* Minimum */

//  Determine number of elements in an array

#define ELEMENTS(array) (sizeof(array)/sizeof((array)[0]))

//  Assertion checking for Windows

#ifndef NDEBUG
#define assert(x) { if (!(x)) { char erm[128]; wsprintf((LPSTR) erm, \
        (LPSTR) "Assertion %s failed at line %d of file %s.", (LPCSTR) #x, __LINE__,(LPSTR) __FILE__); \
        FatalAppExit(0, (LPCSTR) erm); }}
#else
#define assert(x)
#endif

//	Ticker debugging

//#define TICKER_DEBUG
#ifdef TICKER_DEBUG
extern int tickerTicks;
extern char *tickerWhat;
#define Ticker(x) tickerWhat = (x ## " ")
#else
#define Ticker(x)
#endif


//	Make sure no debug output remains in production builds: use Honk(x) for debug MessageBeep(x)

#ifdef NDEBUG
#ifdef OutputDebugString
#undef OutputDebugString
#endif
#define OutputDebugString(x) DebugOutputInProductionBuild()
#define Honk(x) DebugOutputInProductionBuild()
#else
#define Honk(x)	MessageBeep(x)
#endif

extern char szString[128];		// Variable to load resource strings
#define hInst	 hMainInstance  // Redefinitions for screen saver lib compatibility
#define hWndMain hMainWindow
extern HINSTANCE hInst;			// Class instance pointer
extern HWND hWndMain;			// Main window pointer
extern double faketime;         // Time for simulation / testing
extern int ImageWid, ImageHgt;	// Image width and height
extern int showDateTime;		// Show date and time ?
extern int forcePalette;		// Force palette even if > 8 bit display
extern int usePalette;			// Should palette be used ?
extern char *loadError;			// Error message for image load
extern int changeTime;			// New image after this number of seconds
extern int randomPosition;		// Show slides in random screen position ?
extern TEXTMETRIC tmx;			// Standard font text metric
extern COLORREF skycolour;		// Colour for legends
extern BOOL bailedOut;          // Bailed out of last loop

#define MAX_STAR_CLUSTERS	10	// Maximum star clusters in star fields

//	Parameters

#define DoFloatRangeParams DfrP(fractal_dimension); \
	DfrP(fractal_dimension_clouds); \
	DfrP(power_spectrum); \
	DfrP(power_spectrum_clouds); \
	DfrP(ice_level); \
	DfrP(glacier_level);

#define DoIntRangeParams DirP(star_fraction); \
	DirP(star_colour); \
	DirP(star_clusters); \
	DirP(star_cluster_density); \
	DirP(star_cluster_width);

#define DoIntParams DiP(show_planets); \
	DiP(show_clouds); \
	DiP(show_stars); \
	DiP(mesh_size); \
	DiP(right_click_to_copy);

#define DoPropellerParams DoFloatRangeParams; DoIntRangeParams;
#define DoAllParams DoPropellerParams; DoIntParams;

//	Declare all parameter variables

#define DfrP(name) DfP(name##_min); DfP(name##_max)
#define DirP(name) DiP(name##_min); DiP(name##_max)

#define DfP(name) extern double name
#define DiP(name) extern int name
DoAllParams;
#undef DfP
#undef DiP

#define WindowProc(x) LONG FAR PASCAL x(HWND hWnd, UINT Message, WPARAM wParam, LPARAM lParam)

/* Dialogue service functions. */

#define DialogueProc(name) BOOL FAR PASCAL name(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)

//	From FORGE.C

extern void forge_init(void);
extern void forge_term(void);
extern void synth_setup(void);
extern int synthesise_image(HGLOBAL *LimageBitmap, int *LsizeX, int *LsizeY);
extern int lastPlanetX;						// Horizontal position of last planet
extern int lastPlanetSize;					// Size of last planet

//  From JULIAN.C

extern double jtime(struct tm FAR *t);
extern void jyear(double td, long FAR *yy, int FAR *mm, int FAR *dd),
            jhms(double j, int FAR *h, int FAR *m, int FAR *s);
extern double ucttoj(long year, int mon, int mday,
                     int hour, int min, int sec);
extern int jwday(double j);

//	From LOADIMAGE.C

extern int loadImage(FILE *input_file, HGLOBAL *LimageBitmap,
					 int *LsizeX, int *LsizeY);

//	From PAINTSCR.C

extern int screenX, screenY;
extern void release_image(void);
extern void updviewfrom(HWND hWnd, BOOL repositioned);
extern void ticker(void);
extern BOOL bailout(void);

//	From QUANTIFY.c

extern HGLOBAL quantifyBMP(HGLOBAL imageBitmapIn);

//  From RANDOM.C

extern void srandom(unsigned long seed);
extern long random(void);

//	From SCRNSAVE.C

extern void GetIniEntries(void);
extern void GetIniSettings(void);

//	From SCRNWIND.C

#ifdef TRACY
extern void Blooie(char *s);
#endif
extern void set_tm_time(struct tm *t, BOOL islocal);
extern void findThemeFile(void);

//	From SPECREND.C

extern void black_body_rgb(double temperature, double *r, double *g, double *b);

//	From UTIL.C

extern void ssavetime(HDC hDC, struct tm lt, RECT tr, COLORREF tcol);
extern void localtimeformat(void);
extern char *rstring(int resid);
