/*

			Screen Saver Configuration Dialogues

*/

#include "screensv.h"

/* Function prototypes */

static void WriteProfileInt(LPSTR key, LPSTR tag, int i);

/* Global used by SCRNSAVE.LIB. Required for all screen savers. */

char szAppName[40];

/* Globals exported. */

char szName[]="Terranova Screen Saver";

/* Externals defined in SCRNSAVE.LIB. Required for all screen savers. */

HINSTANCE hMainInstance;
HWND hMainWindow;
char szName[TITLEBARNAMELEN];
char szIniFile[MAXFILELEN];
char szScreenSaver[22];
char szHelpFile[MAXFILELEN];
char szNoHelpMemory[BUFFLEN];
UINT MyHelpMessage;
HOOKPROC fpMessageFilter;

#define Parameter(type, name, defval) \
	type name = defval; \
	type name##_def = defval

#define FloatParam(name, defval) Parameter(double, name, defval)
#define IntParam(name, defval) Parameter(int, name, defval)

#define RangeParam(type, name, minval, maxval, umin, umax) \
	Parameter(type, name##_min, minval); \
	Parameter(type, name##_max, maxval); \
	Parameter(type, name##_umin, umin); \
	Parameter(type, name##_umax, umax);
	
#define FloatRangeParam(name, minval, maxval, umin, umax) RangeParam(double, name, minval, maxval, umin, umax)

#define IntRangeParam(name, minval, maxval, umin, umax) RangeParam(int, name, minval, maxval, umin, umax)

FloatRangeParam(fractal_dimension, 2.0, 2.7, 1.0, 3.0);
FloatRangeParam(fractal_dimension_clouds, 1.9, 2.3, 1.0, 3.0);
FloatRangeParam(power_spectrum, 1.0, 1.5, 0.1, 4.0);
FloatRangeParam(power_spectrum_clouds, 0.6, 0.8, 0.1, 4.0);
FloatRangeParam(ice_level, 0.2, 0.6, 0.0, 1.0);
FloatRangeParam(glacier_level, 0.6, 0.85, 0.0, 1.0);

IntRangeParam(star_fraction, 50, 75, 0, 1000);
IntRangeParam(star_colour, 100, 150, 0, 1000);
IntRangeParam(star_clusters, -3, 1, -10000, MAX_STAR_CLUSTERS);
IntRangeParam(star_cluster_density, 10, 100, 0, 500);
IntRangeParam(star_cluster_width, 10, 30, 0, 200);

IntParam(show_planets, TRUE);
IntParam(show_clouds, TRUE);
IntParam(show_stars, TRUE);
IntParam(mesh_size, 512);
IntParam(right_click_to_copy, TRUE);

/* RegisterDialogClasses -- Entry point for registering window
							classes required by configuration dialog box. */

BOOL WINAPI RegisterDialogClasses(HANDLE hInst)
{
    return TRUE;
}

//	helpDialogue  --  Display the help dialogue

DialogueProc(helpDialogue)
{
	char *helpText, *eof, *helpTextTerminated = NULL;
	HRSRC htr;

    switch (message) {
        case WM_INITDIALOG:
			htr = FindResource(hMainInstance, "HELPTEXT", "HELPTEXT");
			if (htr != NULL) {
				helpText = LoadResource(hMainInstance, htr);
				if (helpText != NULL) {
					eof = strstr(helpText, "--EOF--");
					if (eof != NULL) {
						helpTextTerminated = malloc((eof - helpText) + 2);

						if (helpTextTerminated != NULL) {
							memcpy(helpTextTerminated, helpText, eof - helpText);
							helpTextTerminated[eof - helpText] = EOS;
						}
					}
				}
			}
			FreeResource(helpText);
			SetDlgItemText(hDlg, IDC_HELP_TEXT, (helpTextTerminated != NULL) ?
				helpTextTerminated : "Oops!  Couldn't load help text from resource.\r\n");
			if (helpTextTerminated != NULL) {
				free(helpTextTerminated);
			}
			return TRUE;

        case WM_COMMAND:
            switch (wParam) {
                case IDOK:
                    EndDialog(hDlg, TRUE);
                    return TRUE;

            }
            break;
    }
    return FALSE;
}

//	creditsDialogue  --  Display the credits dialogue

DialogueProc(creditsDialogue)
{
    switch (message) {
        case WM_COMMAND:
            switch (wParam) {
                case IDOK:
                    EndDialog(hDlg, TRUE);
                    return TRUE;

            }
            break;
    }
    return FALSE;
}

//	fixMesh  --  Make sure mesh size is sane

static void fix_mesh(void)
{
	int i, c, d, b = -1;

	for (i = 128; i <= 1024; i <<= 1) {
		d = abs(i - mesh_size);
		if (b < 0 || d < b) {
			b = d;
			c = i;
		}
	}
	mesh_size = c;
}

//	saneRanges  --  Make sure ranges pass sanity check

static void saneRanges(void)
{
	int i;
	double r;

#undef DfrP
#undef DirP
#define MakeSane(name, var)	var = min(name##_min, name##_max); \
							name##_max = max(name##_min, name##_max); \
							name##_min = var; \
							name##_min = max(name##_min, name##_umin); \
							name##_max = min(name##_max, name##_umax);

#define DfrP(name) MakeSane(name, r);
#define DirP(name) MakeSane(name, i);

	DoFloatRangeParams; DoIntRangeParams;

#undef DfrP
#undef DirP
#define DfrP(name) DfP(name##_min); DfP(name##_max)
#define DirP(name) DiP(name##_min); DiP(name##_max)
}

//	propellerDialogue  --  Advanced propeller-head configuration dialogue

DialogueProc(propellerDialogue)
{
	int i;
	char s[128];

    switch (message) {
        case WM_INITDIALOG:
#define DfP(name) sprintf(s, "%.4g", name); SetDlgItemText(hDlg, IDC_PROP_##name, s)
#define DiP(name) SetDlgItemInt(hDlg, IDC_PROP_##name, name, TRUE)
			DoPropellerParams;
#undef DiP
#undef DfP

			for (i = 128; i <= 1024; i <<= 1) {
				sprintf(s, "%d", i);
				SendDlgItemMessage(hDlg, IDC_PROP_mesh_size, CB_ADDSTRING, 0, (LPARAM) s);
			}
			fix_mesh();
			sprintf(s, "%d", mesh_size);
			SendDlgItemMessage(hDlg, IDC_PROP_mesh_size, CB_SELECTSTRING, -1, (LPARAM) s);
            return TRUE;

        case WM_COMMAND:
            switch (wParam) {
                case IDOK:
#define DfP(name) GetDlgItemText(hDlg, IDC_PROP_##name, s, (sizeof s) - 2); sscanf(s, "%lf", &name)
#define DiP(name) name = GetDlgItemInt(hDlg, IDC_PROP_##name, NULL, TRUE)
					DoPropellerParams;
#undef DiP
#undef DfP
					saneRanges();
					i = SendDlgItemMessage(hDlg, IDC_PROP_mesh_size, CB_GETCURSEL, 0, 0);
					if (i != CB_ERR) {
						mesh_size = 128 << i;	
					} else {
						mesh_size = 512;
					}
                    EndDialog(hDlg, TRUE);
                    return TRUE;

                case IDCANCEL:
                    EndDialog(hDlg, FALSE);
                    return TRUE;

				case IDC_PROP_DEFAULTS:
#define DfP(name) name = name##_def
#define DiP(name) name = name##_def
					DoPropellerParams;
#undef DiP
#undef DfP
					SendDlgItemMessage(hDlg, IDC_PROP_mesh_size, CB_RESETCONTENT, 0, 0);
					propellerDialogue(hDlg, WM_INITDIALOG, 0, 0);
					return TRUE;
            }
            break;

        default:
			break;
    }
    return FALSE;
}

/* ScreenSaverConfigureDialog  --  Dialogue box function for
								   screen saver configuration dialogue. */

DialogueProc(ScreenSaverConfigureDialog)
{
	BOOL intok;
	int is;
	char s[128];

    switch (message) {
        case WM_INITDIALOG:
            GetIniEntries();
            GetIniSettings();
			saneRanges();
			CheckDlgButton(hDlg, IDC_CO_PLANETS, show_planets); 
			CheckDlgButton(hDlg, IDC_CO_CLOUDS, show_clouds); 
			CheckDlgButton(hDlg, IDC_CO_STARS, show_stars); 

			CheckDlgButton(hDlg, IDC_CO_DATE_TIME, showDateTime); 
			CheckDlgButton(hDlg, IDC_CO_PALETTE, forcePalette); 
			CheckDlgButton(hDlg, IDC_CO_right_click_to_copy, right_click_to_copy); 
			CheckDlgButton(hDlg, IDC_CO_POS_RANDOM, randomPosition); 
			CheckDlgButton(hDlg, IDC_CO_POS_CENTRE, !randomPosition);
			SetDlgItemInt(hDlg, IDC_CO_CHANGE_TIME, changeTime, FALSE);
            return TRUE;

        case WM_COMMAND:
            switch (wParam) {
                case IDOK:
					show_planets = IsDlgButtonChecked(hDlg, IDC_CO_PLANETS);
					show_clouds = IsDlgButtonChecked(hDlg, IDC_CO_CLOUDS);
					show_stars = IsDlgButtonChecked(hDlg, IDC_CO_STARS);
					if (!show_planets && !show_clouds && !show_stars) {
						show_planets = show_clouds = show_stars = TRUE;
					}

					showDateTime = IsDlgButtonChecked(hDlg, IDC_CO_DATE_TIME);
					forcePalette = IsDlgButtonChecked(hDlg, IDC_CO_PALETTE);
					right_click_to_copy = IsDlgButtonChecked(hDlg, IDC_CO_right_click_to_copy);
					randomPosition = IsDlgButtonChecked(hDlg, IDC_CO_POS_RANDOM);

					is = GetDlgItemInt(hDlg, IDC_CO_CHANGE_TIME, &intok, FALSE);
					if (intok) {
						changeTime = is;
					} else {
						changeTime = 60;
					}

					/* Write out all configuration parameters. */
                    
					WriteProfileInt(szAppName, rstring(INI_DATE_TIME), showDateTime);
					WriteProfileInt(szAppName, rstring(INI_PALETTE), forcePalette);
					WriteProfileInt(szAppName, rstring(INI_SCREENPOS), randomPosition);
					WriteProfileInt(szAppName, rstring(INI_CHANGETIME), changeTime);

#define DfP(name) sprintf(s, "%.4g", name); WritePrivateProfileString(szAppName, #name, s, szIniFile)					
#define DiP(name) WriteProfileInt(szAppName, #name, name)
					DoAllParams;
#undef DfP
#undef DiP
                    EndDialog(hDlg, TRUE);
                    return TRUE;

                case IDCANCEL:
                    EndDialog(hDlg, FALSE);
                    return TRUE;

				case IDC_CO_CREDITS:
					DialogBox(hMainInstance, MAKEINTRESOURCE(DLG_CREDITS),
						hDlg, creditsDialogue);
					return TRUE;

				case IDC_CO_HELP:
					DialogBox(hMainInstance, MAKEINTRESOURCE(DLG_HELP),
						hDlg, helpDialogue);
					return TRUE;

				case IDC_CO_ADVANCED:
					DialogBox(hMainInstance, MAKEINTRESOURCE(DLG_PROPELLER),
						hDlg, propellerDialogue);
					return TRUE;
            }
            break;

        default:
			break;
    }
    return FALSE;
}

/* GetIniSettings -- Get initial settings from WIN.INI

	Params:  hWnd -- Handle to window

	Return:  None
	
	Note that initial installation defaults are set by the default
	arguments to the retrievals of the profile variables.
*/

void GetIniSettings(void)
{
	char s[132];

	showDateTime = GetPrivateProfileInt(szAppName, rstring(INI_DATE_TIME), TRUE, szIniFile);
	forcePalette = GetPrivateProfileInt(szAppName, rstring(INI_PALETTE), FALSE, szIniFile);
	randomPosition = GetPrivateProfileInt(szAppName, rstring(INI_SCREENPOS), TRUE, szIniFile);
	changeTime = GetPrivateProfileInt(szAppName, rstring(INI_CHANGETIME), 60, szIniFile);

#define DfP(name) GetPrivateProfileString (szAppName, #name, "", s, 80, szIniFile); \
				  if (strlen(s) == 0 || sscanf(s, "%lf", &name) != 1) name = name##_def;
#define DiP(name) name = GetPrivateProfileInt(szAppName, #name, name##_def, szIniFile)
					DoAllParams;
#undef DfP
#undef DiP
}

/* WriteProfileInt - Write an unsigned integer value to CONTROL.INI.

	Params:  name - szSection - [section] name in .INI file
		            szKey     - key= in .INI file
					i         - value for key above

	Return:  None
*/

static void WriteProfileInt(LPSTR szSection, LPSTR szKey, int i)
{
    char achBuf[40];

    /* Write out as unsigned because GetPrivateProfileInt() can't
       cope with signed values! */

    wsprintf(achBuf, "%u", i);
    WritePrivateProfileString(szSection, szKey, achBuf, szIniFile);
}

void GetIniEntries(void)
{
	// Load common strings from stringtable...
    LoadString(hMainInstance, idsAppName, szAppName, 40); 
	LoadString(hMainInstance, idsIniFile, szIniFile, MAXFILELEN);
	LoadString(hMainInstance, idsScreenSaver, szScreenSaver, 22);
	LoadString(hMainInstance, idsHelpFile, szHelpFile, MAXFILELEN);
	LoadString(hMainInstance, idsNoHelpMemory, szNoHelpMemory, BUFFLEN);
}
