/*

		Screen Saver Window procedure
                             
*/

#include "screensv.h"

int showDateTime = TRUE;				// Show date and time ?
int forcePalette = 0;					// Force palette even if > 8 bit display
int usePalette = 0;						// Should palette be used ?
int changeTime = 60;					// New image after this number of seconds
int randomPosition = TRUE;				// Show images in random screen position ?
TEXTMETRIC tmx;							// Standard font text metric

COLORREF skycolour = RGB(0, 0, 255);	// Colour for legends

#ifdef TRACY
void Blooie(char *s)
{
	RECT rc;
	HDC hDC;

	hDC = GetDC(hWndMain);
	GetClientRect(hWndMain, &rc);
	SetBkMode(hDC, OPAQUE);
	SetTextColor(hDC, RGB(255, 255, 255));
	SetBkColor(hDC, RGB(255, 0, 0));
	SetTextAlign(hDC, TA_NOUPDATECP);
	TextOut(hDC, 10, 10, s, strlen(s));
	ReleaseDC(hWndMain, hDC);
}
#endif

//  SET_TM_TIME  --  Set time from Windows system or local time

void set_tm_time(struct tm *t, BOOL islocal)
{
#define CtF(tf, sf) t->tf = s.sf

	SYSTEMTIME s;

	if (islocal) {
		GetLocalTime(&s);
	} else {
		GetSystemTime(&s);
	}
	CtF(tm_sec, wSecond);
	CtF(tm_min, wMinute);
	CtF(tm_hour, wHour);
	CtF(tm_mday, wDay);
	CtF(tm_mon, wMonth - 1);
	CtF(tm_year, wYear - 1900);
	CtF(tm_wday, wDayOfWeek);
	//  tm_yday  never used
	//	tm_isdst never used
}

//	SEEDRANDOM  --  Seed the pseudorandom sequence generator

//#define SHOW_SEED
#ifdef SHOW_SEED
unsigned long r_seed;
#endif

static void seedRandom(void)
{
	int i;
	POINT p;
	MEMORYSTATUS ms;
	unsigned long seed;
	
	/*	The following gets all kind of information likely
		to vary from moment to moment and uses it as the initial
		seed for the random number generator.  If any of these
		causes porting problems in the future, just delete them.  */
	
	seed = GetTickCount();
	seed ^= time(NULL);
	seed ^= (long) GetActiveWindow();
	seed ^= GetFreeSpace(0);
	ms.dwLength = sizeof(MEMORYSTATUS);
	GlobalMemoryStatus(&ms);
	seed ^= ms.dwMemoryLoad; 
	seed ^= ms.dwAvailPhys; 
	seed ^= ms.dwAvailPageFile; 
	GetCursorPos(&p);
	seed ^= p.x;
	seed ^= p.y;

#ifdef SHOW_SEED
	r_seed = seed;
#endif

	srandom(seed);
	for (i = 0; i < 11; i++) {
		(void) random();
	}

	i = random() % 23;
	while (i-- > 0) {
		(void) random();
	}
}

/*  SCREENSAVERPROC  --  Screen saver window procedure.  */

WindowProc(ScreenSaverProc)
{
    HDC hDC;
    PAINTSTRUCT ps;         			// holds PAINT information
    RECT cr;							// Client rectangle
    static long cctime;					// Time to display (real or simulated) */
    static long rptime = 0;				// Last time image shifted
    struct tm lt;
    static BOOL repositioned = TRUE;

    switch (Message) {

        case WM_CREATE:
            hDC = GetDC(hWnd);
			SetCursor(NULL);			// Zap cursor before first draw
            GetIniEntries();
            GetIniSettings();			// Get setup defaults
			usePalette = forcePalette || (GetDeviceCaps(hDC, NUMCOLORS) != -1);
            localtimeformat();
			GetTextMetrics(hDC, &tmx);
            srand((unsigned) (GetTickCount() & 0xFFFF));
            ReleaseDC(hWnd, hDC);

			//	Set priority lower than running background tasks

			SetThreadPriority(GetCurrentThread(), THREAD_PRIORITY_BELOW_NORMAL);

			set_tm_time(&lt, TRUE);
			seedRandom();				// Seed the random number generator
			forge_init();
            SetTimer(hWnd, 1, 1000u, NULL);
            break;

        case WM_DESTROY:
            KillTimer(hWnd, 1);
			release_image();
			forge_term();
        	break;

		case WM_RBUTTONDOWN:
			if (right_click_to_copy) {
				HDC hdcMem;
				HBITMAP hBitmap;

				hDC = GetDC(hWnd);
				hdcMem = CreateCompatibleDC(hDC);
				GetClientRect(hWnd, &cr);
				hBitmap = CreateCompatibleBitmap(hDC,
							cr.right, cr.bottom);
				if (hBitmap) {
					SelectObject(hdcMem, hBitmap);
					BitBlt(hdcMem, 0, 0, cr.right, cr.bottom,
							hDC, 0, 0, SRCCOPY);
					OpenClipboard(hWnd);
					EmptyClipboard();
					SetClipboardData(CF_BITMAP, hBitmap);
					CloseClipboard();
					DeleteDC(hdcMem);
					ReleaseDC(hWnd, hDC);
					return TRUE;
				}
				return 0;
			}
			DestroyWindow(hWnd);
			break;
        
        case WM_TIMER:
			InvalidateRect(hWnd, NULL, FALSE);
        	break;

		case WM_ERASEBKGND:
			hDC = (HDC) wParam;
		    GetClientRect(hWnd, &cr);
		    FillRect(hDC, &cr, (HBRUSH) GetStockObject(BLACK_BRUSH));
			repositioned = TRUE;
			return 0;

        case WM_PAINT:
			time(&cctime);        
            memset(&ps, 0, sizeof(PAINTSTRUCT));
            hDC = BeginPaint(hWnd, &ps);
			set_tm_time(&lt, TRUE);
			faketime = jtime(&lt);
            
            /* If it's time, randomly reposition the image within the
               rectangular window.  This prevents burning in the phosphor by
               the constant parts of the image. */

			if ((cctime - rptime) > changeTime) {
            	rptime = cctime;
            	repositioned = TRUE;
			}
			bailedOut = FALSE;

			updviewfrom(hWnd, repositioned);

			if (loadError != NULL) {
				loadError = NULL;
				rptime = 0;
			}

			repositioned = FALSE;

#ifdef SHOW_SEED
			{
				char tbuf[256];
				int obkm;
				COLORREF obkc, otxc;
				UINT otxa;
				RECT tr;

				tr.left = cr.left;
				tr.right = cr.right;
				tr.top = cr.bottom / 2;
				tr.bottom = tr.top + tmx.tmHeight;
				otxa = SetTextAlign(hDC, TA_NOUPDATECP);
				obkm = SetBkMode(hDC, OPAQUE);
				obkc = SetBkColor(hDC, RGB(0, 0, 0));
				otxc = SetTextColor(hDC, skycolour);
				sprintf(tbuf, "Seed: %lu", r_seed);
				DrawText(hDC, tbuf, -1, &tr, DT_LEFT | DT_TOP | DT_NOCLIP | DT_SINGLELINE);
				SetTextAlign(hDC, otxa);
				SetBkMode(hDC, obkm);
				SetBkColor(hDC, obkc);
				SetTextColor(hDC, otxc);
			}			
#endif

            ValidateRgn(hWnd, NULL);

            /* Inform Windows painting is complete */
            EndPaint(hWnd, &ps);
            return 0;
    }
	return DefScreenSaverProc(hWnd, Message, wParam, lParam);
}

