/*

                     Screen Saver Utilities

*/

#include "screensv.h"

double faketime = 0.0;                // Time increment for test mode

static char dateSep[2], timeSep[2], amPM[2][5];
static int dateFormat, timeFormat;

/*  LOCALTIMEFORMAT  --  Retrieve localised date and time format from profile.  */

void localtimeformat(void)
{
	static char context[] = "intl";

	dateFormat = GetProfileInt(context, "iDate", 0);
	timeFormat = GetProfileInt(context, "iTime", 0);
	GetProfileString(context, "sDate", "/", dateSep, 2);
	GetProfileString(context, "sTime", ":", timeSep, 2);
	GetProfileString(context, "s1159", "AM", amPM[0], 5);
	GetProfileString(context, "s2359", "PM", amPM[1], 5);
}

/*  EDTIME  --  Edit time in localised format.  */

static void edtime(char *str, int hh, int mm, int ss)
{
	if (timeFormat == 1) {
		wsprintf(str, Format(0), hh, (LPSTR) timeSep, mm, (LPSTR) timeSep, ss);
	} else {
		wsprintf(str, Format(1), (hh % 12) ? (hh % 12) : 12,
			(LPSTR) timeSep, mm, (LPSTR) timeSep, ss, (LPSTR) amPM[hh / 12]);
	}
}

/*  EDDATE  --  Edit date in localised format.  */

static void eddate(char *str, long yy, int mm, int dd)
{
	switch (dateFormat) {
		case 1:
			wsprintf(str, Format(3),
				(long) dd,
				(LPSTR) dateSep,
				mm,
				(LPSTR) dateSep,
				yy);
			break;

		case 2:
			wsprintf(str, Format(4),
				yy,
				(LPSTR) dateSep,
				mm,
				(LPSTR) dateSep,
				(long) dd);
			break;

		default:
		case 3:
			wsprintf(str, Format(3),
				(long) mm,
				(LPSTR) dateSep,
				dd,
				(LPSTR) dateSep,
				yy);
			break;
	}
}

/*  RSTRING  --  Retrieve a string from the resource file.  */

char *rstring(int resid)
{
#define maxCStrings 10              /* Maximum concurrently used strings */
    static char rstrings[maxCStrings][80];
    static int n = 0;
    int m = n;

    if (LoadString(hInst, resid, rstrings[m], 79) < 0) {
#ifndef NDEBUG
		{	char s[80];
		
			wsprintf(s, "String resource ID %d not found.\r\n", resid);
			OutputDebugString(s);
		}
#endif    
        strcpy(rstrings[m], "");
    }
    n = (n + 1) % maxCStrings;
    return rstrings[m];
}

/*  SSAVETIME  --  Edit date and time for screen saver display.  */

void ssavetime(HDC hDC, struct tm lt, RECT tr, COLORREF tcol)
{
	if (showDateTime) {
		char tbuf[256];
		int obkm;
		COLORREF obkc, otxc;
		UINT otxa;
#define GARDOL "               "

		otxa = SetTextAlign(hDC, TA_NOUPDATECP);
		obkm = SetBkMode(hDC, OPAQUE);
		obkc = SetBkColor(hDC, RGB(0, 0, 0));
		otxc = SetTextColor(hDC, tcol);

		strcpy(tbuf, GARDOL);
		edtime(tbuf + strlen(tbuf), lt.tm_hour, lt.tm_min, lt.tm_sec);
		strcat(tbuf, " ");
		strcat(tbuf, rstring(IDS_DAY_NAMES + lt.tm_wday));
		strcat(tbuf, " ");
		eddate(tbuf + strlen(tbuf), (long) (lt.tm_year + 1900), lt.tm_mon + 1, lt.tm_mday);
#ifdef TICKER_DEBUG
		sprintf(tbuf + strlen(tbuf), " [%s%d]", tickerWhat, tickerTicks);
#endif
		strcat(tbuf, GARDOL);
		DrawText(hDC, tbuf, -1, &tr, DT_CENTER | DT_TOP | DT_NOCLIP | DT_SINGLELINE);
		SetTextAlign(hDC, otxa);
		SetBkMode(hDC, obkm);
		SetBkColor(hDC, obkc);
		SetTextColor(hDC, otxc);
	}
}


